/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.fragment;

import java.util.ArrayList;
import java.util.List;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.fragment.FragmentUtilsTest")
public class FragmentUtils {
    @TestMethod(value="testSplit")
    protected static List<IAtomContainer> splitMolecule(IAtomContainer atomContainer, IBond bond) {
        ArrayList<IAtomContainer> ret = new ArrayList<IAtomContainer>();
        for (IAtom atom : bond.atoms()) {
            IAtom excludedAtom = atom.equals(bond.getAtom(0)) ? bond.getAtom(1) : bond.getAtom(0);
            List<IBond> part = new ArrayList<IBond>();
            part.add(bond);
            part = FragmentUtils.traverse(atomContainer, atom, part);
            IAtomContainer partContainer = FragmentUtils.makeAtomContainer(atom, part, excludedAtom);
            if (partContainer.getAtomCount() > 2 && partContainer.getAtomCount() != atomContainer.getAtomCount()) {
                ret.add(partContainer);
            }
            part.remove(0);
            partContainer = FragmentUtils.makeAtomContainer(atom, part, excludedAtom);
            if (partContainer.getAtomCount() <= 2 || partContainer.getAtomCount() == atomContainer.getAtomCount()) continue;
            ret.add(partContainer);
        }
        return ret;
    }

    protected static IAtomContainer makeAtomContainer(IAtom atom, List<IBond> parts, IAtom excludedAtom) {
        IAtomContainer partContainer = DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, new Object[0]);
        partContainer.addAtom(atom);
        for (IBond aBond : parts) {
            for (IAtom bondedAtom : aBond.atoms()) {
                if (bondedAtom.equals(excludedAtom) || partContainer.contains(bondedAtom)) continue;
                partContainer.addAtom(bondedAtom);
            }
            if (aBond.contains(excludedAtom)) continue;
            partContainer.addBond(aBond);
        }
        return partContainer;
    }

    protected static List<IBond> traverse(IAtomContainer atomContainer, IAtom atom, List<IBond> bondList) {
        List<IBond> connectedBonds = atomContainer.getConnectedBondsList(atom);
        for (IBond aBond : connectedBonds) {
            if (bondList.contains(aBond)) continue;
            bondList.add(aBond);
            IAtom nextAtom = aBond.getConnectedAtom(atom);
            if (atomContainer.getConnectedAtomsCount(nextAtom) == 1) continue;
            FragmentUtils.traverse(atomContainer, nextAtom, bondList);
        }
        return bondList;
    }
}

