/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.atomtype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openscience.cdk.Atom;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.atomtype.IAtomTypeMatcher;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.AtomTypeTools;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class MM2AtomTypeMatcher
implements IAtomTypeMatcher {
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(MM2AtomTypeMatcher.class);
    IBond.Order maxBondOrder = IBond.Order.SINGLE;
    private AtomTypeFactory factory = null;
    AtomTypeTools atomTypeTools = null;
    String[] atomTypeIds = new String[]{"C", "Csp2", "C=", "Csp", "HC", "O", "O=", "N", "Nsp2", "Nsp", "F", "CL", "BR", "I", "S", "S+", ">SN", "SO2", "Sthi", "SI", "LP", "HO", "CR3R", "HN", "HOCO", "P", "B", "BTET", "HN2", "C.", "C+", "GE", "SN", "PB", "SE", "TE", "D", "-N=", "CE3R", "N+", "NPYL", "Oar", "Sthi", "N2OX", "HS", "=N=", "NO2", "OM", "HN+", "OR", "Car", "HE", "NE", "AR", "KR", "XE", "MG+2", "PTET", "FE+2", "FE+3", "NI+2", "NI+3", "CO+2", "CO+3", "OX", "OK", "C++", "N=C", "NPD+", "N+=", "N2OX"};

    public MM2AtomTypeMatcher() {
        this.atomTypeTools = new AtomTypeTools();
    }

    private String getSphericalMatcher(IAtomType type) throws CDKException {
        return (String)type.getProperty("cdk:HOSE code spherical matcher");
    }

    private String getSphericalMatcher(String type) throws CDKException {
        return this.getSphericalMatcher(this.factory.getAtomType(type));
    }

    @Override
    @TestMethod(value="testFindMatchingAtomType_IAtomContainer")
    public IAtomType[] findMatchingAtomType(IAtomContainer atomContainer) throws CDKException {
        IAtomType[] types = new IAtomType[atomContainer.getAtomCount()];
        int typeCounter = 0;
        for (IAtom atom : atomContainer.atoms()) {
            types[typeCounter] = this.findMatchingAtomType(atomContainer, atom);
            ++typeCounter;
        }
        return types;
    }

    @Override
    public IAtomType findMatchingAtomType(IAtomContainer atomContainer, IAtom atomInterface) throws CDKException {
        if (this.factory == null) {
            try {
                this.factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/mm2_atomtypes.xml", atomContainer.getBuilder());
            }
            catch (Exception ex1) {
                logger.error("Could not instantiate the AtomType list!", ex1.getMessage());
                logger.debug(ex1);
                throw new CDKException("Could not instantiate the AtomType list!", ex1);
            }
        }
        Atom atom = (Atom)atomInterface;
        logger.debug("****** Configure MM2 AtomType via findMatching ******");
        String atomSphericalMatcher = (String)atom.getProperty("cdk:HOSE code spherical matcher");
        int atomChemicalGroupConstant = (Integer)atom.getProperty("cdk:Chemical Group");
        int atomRingSize = 0;
        Object oRingSize = atom.getProperty("cdk:Part of ring of size");
        if (oRingSize != null) {
            atomRingSize = (Integer)oRingSize;
        }
        logger.debug(" Symbol:" + atom.getSymbol() + " HoseCode>" + atomSphericalMatcher + " ");
        if (atom instanceof IPseudoAtom) {
            return this.factory.getAtomTypes("DU")[0];
        }
        Pattern p1 = null;
        String ID = "";
        boolean atomTypeFlag = false;
        Matcher mat1 = null;
        IBond.Order tmpMaxBondOrder = IBond.Order.SINGLE;
        this.maxBondOrder = atomContainer.getMaximumBondOrder(atom);
        logger.debug("Atom maxBond" + (Object)((Object)this.maxBondOrder) + " ChemicalGroupConstant " + atomChemicalGroupConstant);
        for (int j = 0; j < this.atomTypeIds.length; ++j) {
            tmpMaxBondOrder = this.factory.getAtomType(this.atomTypeIds[j]).getMaxBondOrder();
            logger.debug(j + "ATOM TYPE " + (Object)((Object)tmpMaxBondOrder) + " " + this.getSphericalMatcher(this.atomTypeIds[j]));
            p1 = Pattern.compile(this.getSphericalMatcher(this.atomTypeIds[j]));
            mat1 = p1.matcher(atomSphericalMatcher);
            if (!mat1.matches()) continue;
            ID = this.atomTypeIds[j];
            if (this.atomTypeIds[j].equals("C")) {
                if (atomChemicalGroupConstant != -1) {
                    if (atomRingSize == 3) {
                        ID = "CR3R";
                    } else if (atomChemicalGroupConstant == 5) {
                        ID = "Car";
                    } else if (this.maxBondOrder != IBond.Order.SINGLE) {
                        ID = "Csp2";
                    }
                }
                if (atom.getSymbol().equals("S")) {
                    if (atomChemicalGroupConstant == 8) {
                        ID = "Sthi";
                    } else {
                        p1 = Pattern.compile(this.getSphericalMatcher("S"));
                        mat1 = p1.matcher(atomSphericalMatcher);
                        if (mat1.matches()) {
                            ID = "S";
                        }
                    }
                }
            } else if (this.atomTypeIds[j].equals("Csp2")) {
                if (atomChemicalGroupConstant != -1) {
                    if (atomChemicalGroupConstant == 5) {
                        ID = "Car";
                    } else if (atomRingSize == 3) {
                        ID = "CE3R";
                    }
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("C="))).matcher(atomSphericalMatcher)).matches()) {
                    ID = "C=";
                }
            } else if (this.atomTypeIds[j].equals("O")) {
                if (atomChemicalGroupConstant != -1) {
                    if (atomChemicalGroupConstant == 6) {
                        ID = "Oar";
                    } else if (atomRingSize == 3) {
                        ID = "OR";
                    }
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("OX"))).matcher(atomSphericalMatcher)).matches() & atomChemicalGroupConstant == -1) {
                    ID = "OX";
                }
            } else if (this.atomTypeIds[j].equals("N")) {
                if (atomContainer.getMaximumBondOrder(atom) == IBond.Order.DOUBLE) {
                    ID = "Nsp2";
                }
                if (atomChemicalGroupConstant == 4) {
                    ID = "NPYL";
                } else if (atomChemicalGroupConstant == 10) {
                    ID = "-N=";
                    p1 = Pattern.compile(this.getSphericalMatcher("NPD+"));
                    mat1 = p1.matcher(atomSphericalMatcher);
                    if (mat1.matches()) {
                        ID = "NPD+";
                    }
                } else {
                    p1 = Pattern.compile(this.getSphericalMatcher("Namid"));
                    mat1 = p1.matcher(atomSphericalMatcher);
                    if (mat1.matches() & atomChemicalGroupConstant == -1) {
                        ID = "Nsp2";
                    } else {
                        p1 = Pattern.compile(this.getSphericalMatcher("N2OX"));
                        mat1 = p1.matcher(atomSphericalMatcher);
                        if (mat1.matches() & atomChemicalGroupConstant == -1) {
                            ID = "N2OX";
                        }
                    }
                }
            } else if (this.atomTypeIds[j].equals("Nsp2")) {
                if (atomChemicalGroupConstant == 12) {
                    ID = "=N-";
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("-N="))).matcher(atomSphericalMatcher)).matches() & atomChemicalGroupConstant == -1) {
                    ID = "-N=";
                } else {
                    p1 = Pattern.compile(this.getSphericalMatcher("N=C"));
                    mat1 = p1.matcher(atomSphericalMatcher);
                    if (mat1.matches()) {
                        ID = "N=C";
                    }
                    if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("N2OX"))).matcher(atomSphericalMatcher)).matches()) {
                        ID = "N2OX";
                    }
                    if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("NO2"))).matcher(atomSphericalMatcher)).matches()) {
                        ID = "NO2";
                    }
                    if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("=N="))).matcher(atomSphericalMatcher)).matches()) {
                        ID = "=N=";
                    }
                }
            } else if (this.atomTypeIds[j].equals("HS")) {
                if (atom.getMaxBondOrder() != null && atom.getMaxBondOrder() != IBond.Order.SINGLE) {
                    ID = "HC";
                }
            } else if (this.atomTypeIds[j].equals("HO")) {
                p1 = Pattern.compile(this.getSphericalMatcher("HOC"));
                mat1 = p1.matcher(atomSphericalMatcher);
                if (mat1.matches() & atomChemicalGroupConstant == -1) {
                    ID = "HN2";
                }
                if ((mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("HOCO"))).matcher(atomSphericalMatcher)).matches() & atomChemicalGroupConstant == -1) {
                    ID = "HOCO";
                }
            } else if (this.atomTypeIds[j].equals("HN") && (mat1 = (p1 = Pattern.compile(this.getSphericalMatcher("HN2"))).matcher(atomSphericalMatcher)).matches()) {
                ID = "HN2";
            }
            atomTypeFlag = true;
            logger.debug(" MATCH AtomTypeID:" + j + " " + ID);
            break;
        }
        if (atomTypeFlag) {
            atomTypeFlag = false;
            logger.debug("ID in factory true:" + ID);
            return this.factory.getAtomType(ID);
        }
        logger.debug("NoSuchAtomTypeException: Atom is unkown with Symbol:" + atom.getSymbol() + " does not MATCH AtomType. HoseCode:" + atomSphericalMatcher);
        logger.debug("ID in factory false:" + ID);
        return this.factory.getAtomType("DU");
    }
}

