/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.undoredo;

import org.openscience.cdk.controller.undoredo.IUndoRedoable;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;

public class ReplaceAtomEdit
implements IUndoRedoable {
    private static final long serialVersionUID = -7667903450980188402L;
    private IChemModel chemModel;
    private IAtom oldAtom;
    private IAtom newAtom;
    private String type;

    public ReplaceAtomEdit(IChemModel chemModel, IAtom oldAtom, IAtom newAtom, String type) {
        this.chemModel = chemModel;
        this.oldAtom = oldAtom;
        this.newAtom = newAtom;
        this.type = type;
    }

    @Override
    public void redo() {
        IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)this.oldAtom);
        AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)relevantContainer, (IAtom)this.oldAtom, (IAtom)this.newAtom);
    }

    @Override
    public void undo() {
        IAtomContainer relevantContainer = ChemModelManipulator.getRelevantAtomContainer((IChemModel)this.chemModel, (IAtom)this.newAtom);
        AtomContainerManipulator.replaceAtomByAtom((IAtomContainer)relevantContainer, (IAtom)this.newAtom, (IAtom)this.oldAtom);
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    public String getPresentationName() {
        return this.type;
    }
}

