/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.diff.tree;

import java.util.Iterator;
import javax.vecmath.Point2d;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.tools.diff.tree.AbstractDifferenceList;
import org.openscience.cdk.tools.diff.tree.DoubleDifference;
import org.openscience.cdk.tools.diff.tree.IDifference;
import org.openscience.cdk.tools.diff.tree.IDifferenceList;

@TestClass(value="org.openscience.cdk.tools.diff.tree.Point2dDifferenceTest")
public class Point2dDifference
extends AbstractDifferenceList
implements IDifferenceList {
    private String name;

    private Point2dDifference(String name) {
        this.name = name;
    }

    @TestMethod(value="testDiff,testSame,testTwoNull,testOneNull")
    public static IDifference construct(String name, Point2d first, Point2d second) {
        if (first == null && second == null) {
            return null;
        }
        Point2dDifference totalDiff = new Point2dDifference(name);
        totalDiff.addChild(DoubleDifference.construct("x", first == null ? null : Double.valueOf(first.x), second == null ? null : Double.valueOf(second.x)));
        totalDiff.addChild(DoubleDifference.construct("y", first == null ? null : Double.valueOf(first.y), second == null ? null : Double.valueOf(second.y)));
        if (totalDiff.childCount() == 0) {
            return null;
        }
        return totalDiff;
    }

    @TestMethod(value="testToString")
    public String toString() {
        if (this.differences.size() == 0) {
            return "";
        }
        StringBuffer diffBuffer = new StringBuffer();
        diffBuffer.append(this.name).append('{');
        Iterator<IDifference> children = this.getChildren().iterator();
        while (children.hasNext()) {
            diffBuffer.append(children.next().toString());
            if (!children.hasNext()) continue;
            diffBuffer.append(", ");
        }
        diffBuffer.append('}');
        return diffBuffer.toString();
    }
}

