/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.controller.edit;

import java.util.Set;
import org.openscience.cdk.controller.Changed;
import org.openscience.cdk.controller.edit.AbstractEdit;
import org.openscience.cdk.controller.edit.IEdit;
import org.openscience.cdk.interfaces.IAtomContainer;

public class OptionalUndoEdit
extends AbstractEdit {
    private IEdit wrappedEdit;
    private boolean isFinal;

    public static OptionalUndoEdit wrap(IEdit edit, boolean isFinal) {
        return new OptionalUndoEdit(edit, isFinal);
    }

    public static OptionalUndoEdit wrapFinal(IEdit edit) {
        return new OptionalUndoEdit(edit, true);
    }

    public static OptionalUndoEdit wrapNonFinal(IEdit edit) {
        return new OptionalUndoEdit(edit, false);
    }

    private OptionalUndoEdit(IEdit edit, boolean isFinal) {
        this.isFinal = isFinal;
        this.wrappedEdit = edit;
    }

    @Override
    public void redo() {
        if (this.isFinal) {
            this.wrappedEdit.redo();
        }
    }

    @Override
    public void undo() {
        if (this.isFinal) {
            this.wrappedEdit.undo();
        }
    }

    @Override
    public void execute(IAtomContainer ac) {
        this.model = ac;
        if (!this.isFinal) {
            this.wrappedEdit.redo();
        }
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public Set<Changed> getTypeOfChanges() {
        return this.wrappedEdit.getTypeOfChanges();
    }
}

