/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class MMFF94BasedAtomTypePattern {
    private List<Pattern> atomTypePatterns = new Vector<Pattern>();

    MMFF94BasedAtomTypePattern() {
        this.createPattern();
    }

    public List<Pattern> getAtomTypePatterns() {
        return this.atomTypePatterns;
    }

    private void createPattern() {
        this.atomTypePatterns.add(Pattern.compile("C-[0-4][+]?+;[A-Za-z+-]{0,6}[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("[C]-[1-3];[H]{0,2}+[A-Za-z]*+=[C]{1}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("[CS]-[0-3];[H]{0,2}+[A-Za-z]*+=[NOPS]{1}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("C-[0-2];[H]{0,1}+%.*+"));
        this.atomTypePatterns.add(Pattern.compile("[CS]-[3][-]?+;[A-Za-z]{0,2}+=O=O[A-Za-z]{0,2}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("C-[2-3];[H]{0,1}+=N[+]?+N[+]?+C[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("C-1[-]?+;%N[+]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("C-2;=N[+]?+N[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("C-[0-4];[A-Za-z+-]{1,6}[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("C-[0-4];[A-Za-z+-]{1,6}[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("[C]-[0-3];[H]{0,2}+[A-Za-z]*+=[A-Z]{1,2}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("[C]-[0-3];[H]{0,2}+[A-Za-z]*+=[A-Z]{1,2}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("C-[2-3];[H]?+[C]{1}+[A-Z&&[^C]]{1}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("C-[2-3];[H]?+[C]{2,3}+[(][HC]{0,2}+[,]?+[A-Z&&[^C]]{1}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("NO PATTERN"));
        this.atomTypePatterns.add(Pattern.compile("H-[1];[C,Si][+]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[1];O[(].{2,}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[0-1];[N][(].*+"));
        this.atomTypePatterns.add(Pattern.compile("H-1;O[(]C/[H]{0,1}+=O.*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[0-1];N[(][H]{0,2}+=C.*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[0-1];N[(][H]{0,2}+=[A-Z[^C]].*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[0-1];O[(]C/[H]?+=C.*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[0-1];O[(]H[)]"));
        this.atomTypePatterns.add(Pattern.compile("H-[0-1];O[(][H]{0,2}+=?+S.*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[0-1];[N][+][(].*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[1];O[+][(][A-Za-z[^=]]{1,4}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[1];O[+][(].*+"));
        this.atomTypePatterns.add(Pattern.compile("H-[1];[SP].*+"));
        this.atomTypePatterns.add(Pattern.compile("O-[2];[HCSN]{1,2}+[+]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("O-[1];=.*+"));
        this.atomTypePatterns.add(Pattern.compile("O-[1];=[A-Za-z[^C]]{1,2}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("O-[1][-]?+;.*+"));
        this.atomTypePatterns.add(Pattern.compile("O-[3][+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("O-[1-2][+];[A-Za-z]{0,2}+=.*+"));
        this.atomTypePatterns.add(Pattern.compile("O-[1-2];[H]{0,2}+.*"));
        this.atomTypePatterns.add(Pattern.compile("O-2;CC.=C.*+&.*+&.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[0-3];[A-Za-z &&[^=%]]{1,3}+.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-3];[H]{0,2}+[A-Za-z]*+=[CN].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-3];[H]{0,3}+[C]*+[(].*+=C.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-2][+]?+;%.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2][+]?+;=[NC]=[NC][-]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-1[+-]?+;%?+=?+N[+]?+[(]=?+N[-]?+.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-4[+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2-3][+]?+;=[A-Z[^O]]{1,2}+O[-]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-3];[H]{0,2}+[O]{0,1}+[-]?+[A-Za-z[^O]]{0,2}+[O]{0,1}+[-]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-3][+]?+;[H]{0,2}+[A-Za-z]{0,6}+[(].*+%C.*+%N.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-3[+];=OCO-.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-2;[A-Z[^O]]{0,1}=O[A-Z[^O]]{0,1}[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-3];[CH]{1,3}.{1}+[A-Z]{0,3}+[,]?+=OC.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-1-2];[CH]{1}+=S[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-3][+];[H]{0,2}+=[A-Za-z]{1,3}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[0-3][+];[H]{0,2}+=C[(][A-Za-z[^=%N]]{0,7}[N]{1}+/.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[0-3][+];[H]{0,2}+=C[(][N]]{2}+/.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-2][+];[H]{0,1}+%[NC][-]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-2][-];[H]{0,1}+S[A-Z]{0,1}+[(][H]{0,4}+=?+O[-]?+.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2][-];.*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2-3];[H]{0,1}+[A-Za-z[^N]]{2,3}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2-3];[H]{0,1}+[A-Za-z[^N]]{2,3}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2-3][+];[H]{0,1}+[A-Za-z[^NO]]{2,3}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2-3][+]?+;[H]{0,1}+=?+[N,O,S]{0,1}+[+]?+=?+C[+]?+[N,O,S]{0,1}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[2,3];[H]{0,1}+=CC[(][H]{0,3}+=?+[A-Z[^C]].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[3][+];[A-Z[^ON]]{2}+O[-]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("N-[3][+];[A-Z[^ON]]{2}+O[-]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("NO PATTERN"));
        this.atomTypePatterns.add(Pattern.compile("N-[1-3];[H]{0,1}+[A-Za-z]++[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[1-2];[HCNO]{1,2}+[+]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[1];[H]{0,2}+=C.*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[1-3];[H]{0,2}+=[ON].*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[3-4];[H]{0,2}+=[OCN]=[OCN]=?+[OCN]{0,2}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[1-2][-]?+;[H]{0,1}+[A-Za-z]{0,2}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[3];=OO[-]?+[A-Za-z]{1,2}+[-]?+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[2];=[A-Za-z]{1,2}=O+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("S-[2];[H]{0,3}+=C.*+"));
        this.atomTypePatterns.add(Pattern.compile("P-[4];.*+"));
        this.atomTypePatterns.add(Pattern.compile("P-[0-3];.*+"));
        this.atomTypePatterns.add(Pattern.compile("P-[2];=C[A-Za-z]{1,2}+[(].*+"));
        this.atomTypePatterns.add(Pattern.compile("F-[0-7][+]?+;.*+"));
        this.atomTypePatterns.add(Pattern.compile("Cl-[0-7][+]?+;.*+"));
        this.atomTypePatterns.add(Pattern.compile("Br-[0-7][+]?+;.*+"));
        this.atomTypePatterns.add(Pattern.compile("I.*+"));
        this.atomTypePatterns.add(Pattern.compile("Si.*+"));
        this.atomTypePatterns.add(Pattern.compile("Cl[4];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Fe2[+].*+"));
        this.atomTypePatterns.add(Pattern.compile("Fe3[+].*+"));
        this.atomTypePatterns.add(Pattern.compile("F-[0-2][-];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Cl-[0-2][-];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Br-[0-2][-];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Li-[0-2][+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Na[+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("K[+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Zn2[+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Ca2[+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Cu[+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Cu2[+];.*+"));
        this.atomTypePatterns.add(Pattern.compile("Mg2[+];.*+"));
    }
}

