/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.TripleMatchFilter;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.impl.SimpleReifier;
import com.hp.hpl.jena.graph.impl.TripleStore;
import com.hp.hpl.jena.mem.GraphMemBase;
import com.hp.hpl.jena.mem.GraphMemBulkUpdateHandler;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmallGraphMem
extends GraphMemBase {
    protected Set<Triple> triples = CollectionFactory.createHashedSet();

    public SmallGraphMem() {
        this(ReificationStyle.Minimal);
    }

    public SmallGraphMem(ReificationStyle style) {
        super(style);
    }

    @Override
    protected TripleStore createTripleStore() {
        return null;
    }

    @Override
    public void performAdd(Triple t) {
        if (!this.getReifier().handledAdd(t)) {
            this.triples.add(t);
        }
    }

    @Override
    public void performDelete(Triple t) {
        if (!this.getReifier().handledRemove(t)) {
            this.triples.remove(t);
        }
    }

    @Override
    public int graphBaseSize() {
        return this.triples.size();
    }

    @Override
    public boolean graphBaseContains(Triple t) {
        return this.isSafeForEquality(t) ? this.triples.contains(t) : this.containsByFind(t);
    }

    @Override
    protected void destroy() {
        this.triples = null;
    }

    @Override
    public void clear() {
        this.triples.clear();
        ((SimpleReifier)this.getReifier()).clear();
    }

    @Override
    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new GraphMemBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    @Override
    public ExtendedIterator<Triple> graphBaseFind(TripleMatch m) {
        return SimpleEventManager.notifyingRemove(this, this.triples.iterator()).filterKeep(new TripleMatchFilter(m.asTriple()));
    }
}

