/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.guha.rcdk.view.RcdkDepictor;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.smiles.SmilesParser;

public class MoleculeCell
extends JPanel {
    private int preferredWidth;
    private int preferredHeight;
    private boolean isNew;
    IAtomContainer atomContainer;
    RcdkDepictor depictor;
    BufferedImage bufferedImage;

    public MoleculeCell(IAtomContainer atomContainer, RcdkDepictor depictor) throws IOException, CDKException {
        this.preferredHeight = depictor.getHeight();
        this.preferredWidth = depictor.getWidth();
        this.depictor = depictor;
        this.atomContainer = atomContainer;
        this.setPreferredSize(new Dimension(this.preferredWidth, this.preferredHeight));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.bufferedImage = depictor.getImage(atomContainer);
        this.isNew = true;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.isNew) {
            g.drawImage(this.bufferedImage, 0, 0, this);
            this.isNew = false;
        } else {
            try {
                this.depictor.setWidth(this.getWidth());
                this.depictor.setHeight(this.getHeight());
                g.drawImage(this.depictor.getImage(this.atomContainer), 0, 0, this);
            }
            catch (CDKException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws CDKException, IOException {
        SmilesParser sp = new SmilesParser(DefaultChemObjectBuilder.getInstance());
        IAtomContainer container = sp.parseSmiles("[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].[Na+].CCCCc1ccc(CO[C@H]2O[C@H](COS(=O)(=O)[O-])[C@@H](OS(=O)(=O)[O-])[C@H](OS(=O)(=O)[O-])[C@@H]2O[C@H]3O[C@H](COS(=O)(=O)[O-])[C@@H](OS(=O)(=O)[O-])[C@H](O[C@H]4O[C@H](COS(=O)(=O)[O-])[C@@H](OS(=O)(=O)[O-])[C@H](O[C@H]5O[C@H](COS(=O)(=O)[O-])[C@@H](OS(=O)(=O)[O-])[C@H](OS(=O)(=O)[O-])[C@@H]5OS(=O)(=O)[O-])[C@@H]4OS(=O)(=O)[O-])[C@@H]3OS(=O)(=O)[O-])cc1 ");
        RcdkDepictor depictor = new RcdkDepictor(300, 300, 1.3, "cow", "off", "reagents", true, false, 100, "");
        MoleculeCell mcell = new MoleculeCell(container, depictor);
        JFrame frame = new JFrame("Molecule Cell");
        frame.getContentPane().add(mcell);
        frame.pack();
        frame.setVisible(true);
    }
}

