/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.PhosphorusMonomer;
import org.jmol.viewer.Viewer;

class NucleicMonomer
extends PhosphorusMonomer {
    static final byte[] interestingNucleicAtomIDs = new byte[]{-13, 69, -51, 68, 69, 64, 65, 66, 67, -71, -72, -73, -74, -80, -79, -75, -78, -77, -76, -81, -46, -47, 5, -60, 9, -13, 8};
    boolean hasRnaO2Prime;
    boolean isPurine;
    boolean isPyrimidine;
    static final byte[] ring5OffsetIndexes = new byte[]{3, 10, 11, 12, 8};

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes, Atom[] atoms) {
        byte[] offsets = NucleicMonomer.scanForOffsets(firstAtomIndex, specialAtomIndexes, interestingNucleicAtomIDs);
        if (offsets == null) {
            return null;
        }
        NucleicMonomer nucleicMonomer = new NucleicMonomer(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        return nucleicMonomer;
    }

    NucleicMonomer(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, byte[] offsets) {
        super(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
        if (offsets[0] == -1) {
            byte leadOffset = offsets[20];
            if (leadOffset == -1) {
                leadOffset = offsets[21];
            }
            if (leadOffset == -1) {
                leadOffset = offsets[22];
            }
            offsets[0] = leadOffset;
        }
        this.hasRnaO2Prime = offsets[2] != -1;
        this.isPyrimidine = offsets[9] != -1;
        this.isPurine = offsets[10] != -1 && offsets[11] != -1 && offsets[12] != -1;
    }

    boolean isNucleicMonomer() {
        return true;
    }

    boolean isDna() {
        return !this.hasRnaO2Prime;
    }

    boolean isRna() {
        return this.hasRnaO2Prime;
    }

    boolean isPurine() {
        return this.isPurine;
    }

    boolean isPyrimidine() {
        return this.isPyrimidine;
    }

    boolean isGuanine() {
        return this.offsets[18] != -1;
    }

    byte getProteinStructureType() {
        return this.hasRnaO2Prime ? (byte)5 : 4;
    }

    Atom getN1() {
        return this.getAtomFromOffsetIndex(5);
    }

    Atom getN3() {
        return this.getAtomFromOffsetIndex(7);
    }

    Atom getN2() {
        return this.getAtomFromOffsetIndex(18);
    }

    Atom getO2() {
        return this.getAtomFromOffsetIndex(9);
    }

    Atom getO6() {
        return this.getAtomFromOffsetIndex(14);
    }

    Atom getN4() {
        return this.getAtomFromOffsetIndex(15);
    }

    Atom getN6() {
        return this.getAtomFromOffsetIndex(17);
    }

    Atom getO4() {
        return this.getAtomFromOffsetIndex(13);
    }

    Atom getAtom(byte specialAtomID) {
        return this.getSpecialAtom(interestingNucleicAtomIDs, specialAtomID);
    }

    Point3f getAtomPoint(byte specialAtomID) {
        return this.getSpecialAtomPoint(interestingNucleicAtomIDs, specialAtomID);
    }

    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(this.offsets[23] != -1 ? 23 : 24);
    }

    Atom getO3PrimeAtom() {
        return this.getAtomFromOffsetIndex(24);
    }

    Atom getPhosphorusAtom() {
        return this.getAtomFromOffsetIndex(25);
    }

    Atom getO5PrimeAtom() {
        return this.getAtomFromOffsetIndex(22);
    }

    Atom getC3PrimeAtom() {
        return this.getAtomFromOffsetIndex(26);
    }

    void getBaseRing6Points(Point3f[] ring6Points) {
        int i = 6;
        while (--i >= 0) {
            Atom atom = this.getAtomFromOffsetIndex(i + 3);
            ring6Points[i] = atom;
        }
    }

    boolean maybeGetBaseRing5Points(Point3f[] ring5Points) {
        if (this.isPurine) {
            int i = 5;
            while (--i >= 0) {
                Atom atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[i]);
                ring5Points[i] = atom;
            }
        }
        return this.isPurine;
    }

    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        Atom myPhosphorusAtom = this.getPhosphorusAtom();
        if (myPhosphorusAtom == null) {
            return false;
        }
        if (!(possiblyPreviousMonomer instanceof NucleicMonomer)) {
            return false;
        }
        NucleicMonomer other = (NucleicMonomer)possiblyPreviousMonomer;
        return other.getO3PrimeAtom().isBonded(myPhosphorusAtom);
    }

    void findNearestAtomIndex(int x, int y, Closest closest, short madBegin, short madEnd) {
        int radius;
        Viewer viewer = this.chain.frame.viewer;
        Atom competitor = closest.atom;
        Atom lead = this.getLeadAtom();
        Atom o5prime = this.getO5PrimeAtom();
        Atom c3prime = this.getC3PrimeAtom();
        int mar = madBegin / 2;
        if (mar < 1900) {
            mar = 1900;
        }
        if ((radius = viewer.scaleToScreen(lead.getScreenZ(), mar)) < 4) {
            radius = 4;
        }
        if (lead.isCursorOnTop(x, y, radius, competitor) || o5prime.isCursorOnTop(x, y, radius, competitor) || c3prime.isCursorOnTop(x, y, radius, competitor)) {
            closest.atom = lead;
        }
    }

    void setModelClickability() {
        Atom atom = this.getLeadAtom();
        if (this.chain.frame.bsHidden.get(atom.atomIndex)) {
            return;
        }
        int cartoonflag = Viewer.getShapeVisibilityFlag(10);
        int i = 6;
        while (--i >= 0) {
            atom = this.getAtomFromOffsetIndex(i + 3);
            atom.clickabilityFlags |= cartoonflag;
        }
        if (this.isPurine) {
            i = 5;
            while (--i >= 0) {
                atom = this.getAtomFromOffsetIndex(ring5OffsetIndexes[i]);
                atom.clickabilityFlags |= cartoonflag;
            }
        }
    }
}

