/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import netscape.javascript.JSObject;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.XmlReader;
import org.xml.sax.XMLReader;

class XmlArgusReader
extends XmlReader {
    String[] argusImplementedAttributes = new String[]{"order"};
    String[] keepCharsList = new String[]{"name", "x", "y", "z", "formalchg", "atomkey", "atsym"};
    String atomName1;
    String atomName2;
    int bondOrder;
    int elementContext;
    static final int UNSET = 0;
    static final int MOLECULE = 1;
    static final int ATOM = 2;
    static final int BOND = 3;

    XmlArgusReader() {
    }

    XmlArgusReader(XmlReader parent, AtomSetCollection atomSetCollection, BufferedReader reader, XMLReader xmlReader) {
        this.parent = parent;
        this.reader = reader;
        this.atomSetCollection = atomSetCollection;
        new ArgusHandler(xmlReader);
        this.parseReaderXML(xmlReader);
    }

    XmlArgusReader(XmlReader parent, AtomSetCollection atomSetCollection, JSObject DOMNode) {
        this.parent = parent;
        this.atomSetCollection = atomSetCollection;
        this.implementedAttributes = this.argusImplementedAttributes;
        new ArgusHandler().walkDOMTree(DOMNode);
    }

    void processStartElement(String namespaceURI, String localName, String qName, HashMap atts) {
        int i = this.keepCharsList.length;
        while (--i >= 0) {
            if (!this.keepCharsList[i].equals(localName)) continue;
            this.setKeepChars(true);
            break;
        }
        if ("molecule".equals(localName)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(localName)) {
            this.elementContext = 2;
            this.atom = new Atom();
            return;
        }
        if ("bond".equals(localName)) {
            this.elementContext = 3;
            this.atomName1 = null;
            this.atomName2 = null;
            this.bondOrder = this.parseBondToken((String)atts.get("order"));
            return;
        }
    }

    int parseBondToken(String str) {
        float floatOrder = this.parseFloat(str);
        if (Float.isNaN(floatOrder) && str.length() >= 1) {
            str = str.toUpperCase();
            switch (str.charAt(0)) {
                case 'S': {
                    return 1;
                }
                case 'D': {
                    return 2;
                }
                case 'T': {
                    return 3;
                }
                case 'A': {
                    return 4;
                }
            }
            return this.parseInt(str);
        }
        if ((double)floatOrder == 1.5) {
            return 4;
        }
        if (floatOrder == 2.0f) {
            return 2;
        }
        if (floatOrder == 3.0f) {
            return 3;
        }
        return 1;
    }

    void processEndElement(String uri, String localName, String qName) {
        if (this.chars != null && this.chars.length() > 0 && this.chars.charAt(this.chars.length() - 1) == '\n') {
            this.chars = this.chars.substring(0, this.chars.length() - 1);
        }
        if ("molecule".equals(localName)) {
            this.elementContext = 0;
            return;
        }
        if ("atom".equals(localName)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            this.elementContext = 0;
            return;
        }
        if ("bond".equals(localName)) {
            if (this.atomName2 != null) {
                this.atomSetCollection.addNewBond(this.atomName1, this.atomName2, this.bondOrder);
            }
            this.elementContext = 0;
            return;
        }
        if (this.elementContext == 1) {
            if ("name".equals(localName)) {
                this.atomSetCollection.setAtomSetName(this.chars);
                this.setKeepChars(false);
            }
            return;
        }
        if (this.atom != null && this.elementContext == 2) {
            if ("x".equals(localName)) {
                this.atom.x = this.parseFloat(this.chars);
            } else {
                if ("y".equals(localName)) {
                    this.atom.y = this.parseFloat(this.chars);
                    return;
                }
                if ("z".equals(localName)) {
                    this.atom.z = this.parseFloat(this.chars);
                    return;
                }
                if ("atsym".equals(localName)) {
                    this.atom.elementSymbol = this.chars;
                    return;
                }
                if ("formalchg".equals(localName)) {
                    this.atom.formalCharge = this.parseInt(this.chars);
                } else if ("atomkey".equals(localName)) {
                    this.atom.atomName = this.chars;
                }
            }
            this.setKeepChars(false);
            return;
        }
        if (this.elementContext == 3) {
            if ("atomkey".equals(localName)) {
                if (this.atomName1 == null) {
                    this.atomName1 = this.chars;
                } else {
                    this.atomName2 = this.chars;
                }
                this.setKeepChars(false);
            }
            return;
        }
    }

    class ArgusHandler
    extends XmlReader.JmolXmlHandler {
        ArgusHandler() {
            super(XmlArgusReader.this);
        }

        ArgusHandler(XMLReader xmlReader) {
            super(XmlArgusReader.this);
            this.setHandler(xmlReader, this);
        }
    }
}

