/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.openscience.cdk.Atom;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.Bond;
import org.openscience.cdk.Reaction;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.MoleculeSetManipulator;
import org.openscience.cdk.tools.manipulator.ReactionManipulator;

public class EditAction
extends JCPAction {
    private static final long serialVersionUID = -1051272879400028225L;

    public void actionPerformed(ActionEvent event) {
        logger.debug((Object)"Event source: ", (Object)event.getSource().getClass().getName());
        logger.debug((Object)"  IChemObject: ", (Object)this.getSource(event));
        JChemPaintModel jcpModel = this.jcpPanel.getJChemPaintModel();
        Renderer2DModel renderModel = jcpModel.getRendererModel();
        IChemModel chemModel = jcpModel.getChemModel();
        if (this.type.equals("cut")) {
            Object atomInRange = null;
            IChemObject object = this.getSource(event);
            logger.debug((Object)"Source of call: ", (Object)object);
            atomInRange = object instanceof Atom ? (Atom)object : renderModel.getHighlightedAtom();
            if (atomInRange != null) {
                ChemModelManipulator.removeAtomAndConnectedElectronContainers((IChemModel)chemModel, (IAtom)atomInRange);
            } else {
                IBond bond = renderModel.getHighlightedBond();
                if (bond != null) {
                    ChemModelManipulator.removeElectronContainer((IChemModel)chemModel, (IElectronContainer)bond);
                }
            }
            jcpModel.fireChange();
        } else if (this.type.equals("cutSelected")) {
            logger.debug((Object)"Deleting all selected atoms...");
            if (renderModel.getSelectedPart() == null || renderModel.getSelectedPart().getAtomCount() == 0) {
                JOptionPane.showMessageDialog(this.jcpPanel, "No selection made. Please select some atoms first!", "Error warning", 2);
            } else {
                IAtomContainer selected = renderModel.getSelectedPart();
                logger.debug((Object)"Found # atoms to delete: ", selected.getAtomCount());
                for (int i = 0; i < selected.getAtomCount(); ++i) {
                    ChemModelManipulator.removeAtomAndConnectedElectronContainers((IChemModel)chemModel, (IAtom)selected.getAtom(i));
                }
            }
            renderModel.setSelectedPart((IAtomContainer)new AtomContainer());
            jcpModel.fireChange();
        } else if (this.type.equals("selectAll")) {
            renderModel.setSelectedPart(ChemModelManipulator.getAllInOneContainer((IChemModel)jcpModel.getChemModel()));
            ((JButton)this.jcpPanel.lastAction.get(0)).setBackground(Color.LIGHT_GRAY);
            this.jcpPanel.lastAction.set(0, this.jcpPanel.getMoveButton());
            this.jcpPanel.getMoveButton().setBackground(Color.GRAY);
            jcpModel.getControllerModel().setDrawMode(1);
            jcpModel.fireChange();
        } else if (this.type.equals("selectMolecule")) {
            IChemObject object = this.getSource(event);
            if (object instanceof Atom) {
                renderModel.setSelectedPart(ChemModelManipulator.getRelevantAtomContainer((IChemModel)jcpModel.getChemModel(), (IAtom)((Atom)object)));
            } else if (object instanceof IBond) {
                renderModel.setSelectedPart(ChemModelManipulator.getRelevantAtomContainer((IChemModel)jcpModel.getChemModel(), (IBond)((Bond)object)));
            } else {
                logger.warn((Object)"selectMolecule not defined for the calling object ", (Object)object);
            }
            jcpModel.fireChange();
        } else if (this.type.equals("selectFromChemObject")) {
            IChemObject object = this.getSource(event);
            if (object instanceof Atom) {
                AtomContainer container = new AtomContainer();
                container.addAtom((IAtom)((Atom)object));
                renderModel.setSelectedPart((IAtomContainer)container);
                jcpModel.fireChange();
            } else if (object instanceof IBond) {
                AtomContainer container = new AtomContainer();
                container.addBond((IBond)((Bond)object));
                renderModel.setSelectedPart((IAtomContainer)container);
                jcpModel.fireChange();
            } else if (object instanceof Reaction) {
                renderModel.setSelectedPart(ReactionManipulator.getAllInOneContainer((IReaction)((Reaction)object)));
                jcpModel.fireChange();
            } else {
                logger.warn((Object)"Cannot select everything in : ", (Object)object);
            }
        } else if (this.type.equals("selectReactionReactants")) {
            IChemObject object = this.getSource(event);
            if (object instanceof Reaction) {
                Reaction reaction = (Reaction)object;
                renderModel.setSelectedPart(MoleculeSetManipulator.getAllInOneContainer((IMoleculeSet)reaction.getReactants()));
                jcpModel.fireChange();
            } else {
                logger.warn((Object)"Cannot select reactants from : ", (Object)object);
            }
        } else if (this.type.equals("selectReactionProducts")) {
            IChemObject object = this.getSource(event);
            if (object instanceof Reaction) {
                Reaction reaction = (Reaction)object;
                renderModel.setSelectedPart(MoleculeSetManipulator.getAllInOneContainer((IMoleculeSet)reaction.getProducts()));
                jcpModel.fireChange();
            } else {
                logger.warn((Object)"Cannot select reactants from : ", (Object)object);
            }
        } else {
            logger.warn((Object)("Unsupported EditAction: " + this.type));
        }
    }
}

