/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.applications.jchempaint.action;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import javax.swing.undo.UndoableEdit;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.ChemModel;
import org.openscience.cdk.Molecule;
import org.openscience.cdk.MoleculeSet;
import org.openscience.cdk.applications.jchempaint.JChemPaintModel;
import org.openscience.cdk.applications.jchempaint.action.JCPAction;
import org.openscience.cdk.applications.undoredo.AddAtomsAndBondsEdit;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.MDLReader;
import org.openscience.cdk.io.MDLWriter;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.io.SVGWriter;
import org.openscience.cdk.layout.StructureDiagramGenerator;
import org.openscience.cdk.layout.TemplateHandler;
import org.openscience.cdk.renderer.Renderer2DModel;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;

public class CopyPasteAction
extends JCPAction {
    private static final long serialVersionUID = -3343207264261279526L;
    private DataFlavor molFlavor = new DataFlavor("chemical/x-mdl-molfile", "mdl mol file format");
    private DataFlavor svgFlavor = new DataFlavor("image/svg+xml", "scalable vector graphics");
    private DataFlavor cmlFlavor = new DataFlavor("image/cml", "chemical markup language");
    static /* synthetic */ Class class$org$openscience$cdk$Molecule;
    static /* synthetic */ Class class$org$openscience$cdk$ChemFile;
    static /* synthetic */ Class class$java$io$Writer;

    public void actionPerformed(ActionEvent e) {
        block18: {
            try {
                this.handleSystemClipboard();
                logger.info((Object)"  type  ", (Object)this.type);
                logger.debug((Object)"  source ", e.getSource());
                JChemPaintModel jcpModel = this.jcpPanel.getJChemPaintModel();
                Renderer2DModel renderModel = jcpModel.getRendererModel();
                if ("copy".equals(this.type)) {
                    IAtomContainer tocopy = renderModel.getSelectedPart();
                    if (tocopy == null) {
                        return;
                    }
                    Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
                    JcpSelection jcpselection = new JcpSelection(tocopy);
                    sysClip.setContents(jcpselection, null);
                    break block18;
                }
                if (!"paste".equals(this.type)) break block18;
                Clipboard sysClip = Toolkit.getDefaultToolkit().getSystemClipboard();
                Transferable transfer = sysClip.getContents(null);
                MDLReader reader = null;
                if (transfer != null && transfer.isDataFlavorSupported(this.molFlavor)) {
                    String mol = (String)transfer.getTransferData(this.molFlavor);
                    logger.debug((Object)"Dataflavor molFlavor found");
                    reader = new MDLReader((Reader)new StringReader(mol));
                } else if (transfer != null && transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    logger.debug((Object)"Dataflavor stringFlavor found");
                    String content = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                    try {
                        reader = new ReaderFactory().createReader((Reader)new StringReader(content));
                    }
                    catch (Exception exception) {
                        logger.warn((Object)"Pastes string is not recognized.");
                    }
                }
                IAtomContainer topaste = null;
                if (reader != null) {
                    if (reader.accepts(class$org$openscience$cdk$Molecule == null ? (class$org$openscience$cdk$Molecule = CopyPasteAction.class$("org.openscience.cdk.Molecule")) : class$org$openscience$cdk$Molecule)) {
                        topaste = (IAtomContainer)reader.read((IChemObject)new Molecule());
                    } else if (reader.accepts(class$org$openscience$cdk$ChemFile == null ? (class$org$openscience$cdk$ChemFile = CopyPasteAction.class$("org.openscience.cdk.ChemFile")) : class$org$openscience$cdk$ChemFile)) {
                        topaste = ChemFileManipulator.getAllInOneContainer((IChemFile)((ChemFile)reader.read((IChemObject)new ChemFile())));
                    }
                }
                if (topaste == null && transfer != null && transfer.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        SmilesParser sp = new SmilesParser();
                        topaste = sp.parseSmiles((String)transfer.getTransferData(DataFlavor.stringFlavor));
                        StructureDiagramGenerator sdg = new StructureDiagramGenerator((IMolecule)((Molecule)topaste));
                        sdg.setTemplateHandler(new TemplateHandler(topaste.getBuilder()));
                        sdg.generateCoordinates();
                        this.jcpPanel.scaleAndCenterMolecule(topaste, this.jcpPanel.getSize());
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (topaste != null) {
                    topaste = (IAtomContainer)topaste.clone();
                    IChemModel chemModel = jcpModel.getChemModel();
                    GeometryTools.translate2D((IAtomContainer)topaste, (double)25.0, (double)25.0, (HashMap)jcpModel.getRendererModel().getRenderingCoordinates());
                    IMoleculeSet moleculeSet = chemModel.getMoleculeSet();
                    if (moleculeSet == null) {
                        moleculeSet = new MoleculeSet();
                        chemModel.setMoleculeSet(moleculeSet);
                    }
                    moleculeSet.addMolecule((IMolecule)new Molecule(topaste));
                    this.jcpPanel.scaleAndCenterMolecule((IChemModel)((ChemModel)this.jcpPanel.getChemModel()));
                    renderModel.setSelectedPart(topaste);
                    AddAtomsAndBondsEdit edit = new AddAtomsAndBondsEdit(chemModel, topaste, "Pasted something");
                    this.jcpPanel.getUndoSupport().postEdit((UndoableEdit)edit);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    void handleSystemClipboard() {
        Clipboard clipboard = this.jcpPanel.getToolkit().getSystemClipboard();
        Transferable clipboardContent = clipboard.getContents(this);
        DataFlavor[] flavors = clipboardContent.getTransferDataFlavors();
        String text = "System.clipoard content";
        for (int i = 0; i < flavors.length; ++i) {
            text = text + "\n\n Name: " + flavors[i].getHumanPresentableName();
            text = text + "\n MIME Type: " + flavors[i].getMimeType();
            text = text + "\n Class: ";
            Class<?> cl = flavors[i].getRepresentationClass();
            text = cl == null ? text + "null" : text + cl.getName();
        }
        logger.debug((Object)text);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JcpSelection
    implements Transferable,
    ClipboardOwner {
        private DataFlavor[] supportedFlavors;
        String mol;
        String smiles;
        String svg;
        String cml;

        public JcpSelection(IAtomContainer tocopy1) throws Exception {
            this.supportedFlavors = new DataFlavor[]{CopyPasteAction.this.molFlavor, DataFlavor.stringFlavor, CopyPasteAction.this.svgFlavor, CopyPasteAction.this.cmlFlavor};
            Molecule tocopy = new Molecule(tocopy1);
            StringWriter sw = new StringWriter();
            new MDLWriter((Writer)sw).writeMolecule((IMolecule)tocopy);
            this.mol = sw.toString();
            SmilesGenerator sg = new SmilesGenerator();
            this.smiles = sg.createSMILES((IMolecule)tocopy);
            sw = new StringWriter();
            SVGWriter cow = new SVGWriter((Writer)sw);
            cow.write((IChemObject)tocopy);
            cow.close();
            this.svg = sw.toString();
            sw = new StringWriter();
            Class<?> cmlWriterClass = null;
            try {
                cmlWriterClass = this.getClass().getClassLoader().loadClass("org.openscience.cdk.io.CMLWriter");
            }
            catch (Exception exception) {
                JCPAction.logger.error((Object)"Could not load CMLWriter: ", (Object)exception.getMessage());
                JCPAction.logger.debug((Object)exception);
            }
            if (cmlWriterClass != null) {
                cow = (IChemObjectWriter)cmlWriterClass.newInstance();
                Constructor<?> constructor = cow.getClass().getConstructor(class$java$io$Writer == null ? (class$java$io$Writer = CopyPasteAction.class$("java.io.Writer")) : class$java$io$Writer);
                cow = (IChemObjectWriter)constructor.newInstance(sw);
                cow.write((IChemObject)tocopy);
                cow.close();
            }
            this.cml = sw.toString();
        }

        public synchronized DataFlavor[] getTransferDataFlavors() {
            return this.supportedFlavors;
        }

        public boolean isDataFlavorSupported(DataFlavor parFlavor) {
            for (int i = 0; i < this.supportedFlavors.length; ++i) {
                if (!this.supportedFlavors[i].equals(parFlavor)) continue;
                return true;
            }
            return false;
        }

        public synchronized Object getTransferData(DataFlavor parFlavor) throws UnsupportedFlavorException {
            if (parFlavor.equals(CopyPasteAction.this.molFlavor)) {
                return this.mol;
            }
            if (parFlavor.equals(DataFlavor.stringFlavor)) {
                return this.smiles;
            }
            if (parFlavor.equals(CopyPasteAction.this.cmlFlavor)) {
                return this.cml;
            }
            if (parFlavor.equals(CopyPasteAction.this.svgFlavor)) {
                return this.svg;
            }
            throw new UnsupportedFlavorException(parFlavor);
        }

        public void lostOwnership(Clipboard parClipboard, Transferable parTransferable) {
            System.out.println("Lost ownership");
        }
    }
}

