% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BtcAddresses.R
\name{decodeHex}
\alias{decodeHex}
\title{Decoding of a hex string}
\usage{
decodeHex(s)
}
\arguments{
\item{s}{\code{character}, the hex string.}
}
\value{
\code{list}
}
\description{
This function converts a hex string,, whereby the string must not
contain the \code{0x} prefix, to a \code{list} object with the associated
integers as its elements.
}
\examples{
pk <- createPrivateKey()
decodeHex(pk)
}
\references{
\url{https://en.bitcoin.it/wiki/Wallet_import_format},\cr
\url{https://en.bitcoin.it/wiki/Address}
}
\seealso{
Other BtcAdresses: \code{\link{BTCADR-class}},
  \code{\link{PrivKey2PubKey}}, \code{\link{PrivKey2Wif}},
  \code{\link{PubHash2BtcAdr}},
  \code{\link{PubKey2PubHash}}, \code{\link{Wif2PrivKey}},
  \code{\link{base58CheckDecode}},
  \code{\link{base58CheckEncode}}, \code{\link{concatHex}},
  \code{\link{createBtcAdr}},
  \code{\link{createPrivateKey}}, \code{\link{hash160}},
  \code{\link{hash256}}, \code{\link{validBtcAdr}}
}
\author{
Bernhard Pfaff
}
\concept{BtcAdresses}
