% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biom_ply.r
\name{bdply}
\alias{bdply}
\alias{blply}
\title{Apply a function to each subset of an rbiom object.}
\usage{
bdply(biom, vars, FUN, ..., iters = list(), prefix = FALSE)

blply(biom, vars, FUN, ..., iters = list(), prefix = FALSE)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{vars}{A character vector of metadata fields. Each unique combination
of values in these columns will be used to create a subsetted
rbiom object to pass to \code{FUN.} If \code{NULL},
\code{biom} will be passed to \code{FUN} unaltered. Unambiguous
abbreviations of metadata fields are also accepted.}

\item{FUN}{The function to execute on each subset of \code{biom}.
For \code{bdply()}, the returned value will be coerced to a data.frame.
For \code{blply()}, any returned value is unmodified.}

\item{...}{Additional arguments to pass on to \code{FUN}.}

\item{iters}{A named list of values to pass to \code{FUN}. Unlike
\code{...}, these will be iterated over in all combinations.
Default: \code{list()}}

\item{prefix}{When \code{TRUE}, prefixes the names in in \code{iters} with
a '.' in the final data.frame or 'split_labels' attribute.
Default: \code{FALSE}}
}
\value{
For \code{bdply()}, a tibble data.frame comprising the accumulated
outputs of \code{FUN}, along with the columns specified by
\code{vars} and \code{iters}. For \code{blply()}, a named list that has details
about \code{vars} and \code{iters} in \code{attr(,'split_labels')}.
}
\description{
\code{blply()} and \code{bdply()} let you divide your biom dataset into smaller
pieces, run a function on those smaller rbiom objects, and return the
results as a data.frame or list.
}
\details{
You can also specify additional variables for your function to iterate over
in unique combinations.

Calls \code{\link[plyr:ddply]{plyr::ddply()}} or \code{\link[plyr:dlply]{plyr::dlply()}} internally.
}
\examples{
    library(rbiom)
    
    bdply(hmp50, "Sex", `$`, 'n_samples')
    
    blply(hmp50, "Sex", `$`, 'n_samples') \%>\% unlist()
    
    bdply(hmp50, c("Body Site", "Sex"), function (b) {
      adm <- adiv_matrix(b)[,c("Shannon", "Simpson")]
      apply(adm, 2L, mean)
    })
    
    iters <- list(w = c(TRUE, FALSE), d = c("bray", "euclid"))
    bdply(hmp50, "Sex", iters = iters, function (b, w, d) {
      r <- range(bdiv_distmat(biom = b, bdiv = d, weighted = w))
      round(data.frame(min = r[[1]], max = r[[2]]))
    })

}
\seealso{
Other metadata: 
\code{\link{glimpse.rbiom}()}

Other biom: 
\code{\link{biom_merge}()}
}
\concept{biom}
\concept{metadata}
