% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats_table.r
\name{taxa_stats}
\alias{taxa_stats}
\title{Test taxa abundances for associations with metadata.}
\usage{
taxa_stats(
  biom,
  regr = NULL,
  stat.by = NULL,
  rank = -1,
  taxa = 6,
  lineage = FALSE,
  unc = "singly",
  other = FALSE,
  split.by = NULL,
  transform = "none",
  test = "emmeans",
  fit = "gam",
  at = NULL,
  level = 0.95,
  alt = "!=",
  mu = 0,
  p.adj = "fdr"
)
}
\arguments{
\item{biom}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.
Any value accepted by \code{\link[=as_rbiom]{as_rbiom()}} can also be given here.}

\item{regr}{Dataset field with the x-axis (independent; predictive)
values. Must be numeric. Default: \code{NULL}}

\item{stat.by}{Dataset field with the statistical groups. Must be
categorical. Default: \code{NULL}}

\item{rank}{What rank(s) of taxa to display. E.g. \code{"Phylum"},
\code{"Genus"}, \code{".otu"}, etc. An integer vector can also be
given, where \code{1} is the highest rank, \code{2} is the second
highest, \code{-1} is the lowest rank, \code{-2} is the second
lowest, and \code{0} is the OTU "rank". Run \code{biom$ranks} to
see all options for a given rbiom object. Default: \code{-1}.}

\item{taxa}{Which taxa to display. An integer value will show the top n
most abundant taxa. A value 0 <= n < 1 will show any taxa with that
mean abundance or greater (e.g. \code{0.1} implies >= 10\%). A
character vector of taxa names will show only those named taxa.
Default: \code{6}.}

\item{lineage}{Include all ranks in the name of the taxa. For instance,
setting to \code{TRUE} will produce
\verb{Bacteria; Actinobacteria; Coriobacteriia; Coriobacteriales}.
Otherwise the taxa name will simply be \code{Coriobacteriales}. You
want to set this to TRUE when \code{unc = "asis"} and you have taxa
names (such as \emph{Incertae_Sedis}) that map to multiple higher
level ranks. Default: \code{FALSE}}

\item{unc}{How to handle unclassified, uncultured, and similarly ambiguous
taxa names. Options are:
\describe{
\item{\code{"singly"} - }{ Replaces them with the OTU name. }
\item{\code{"grouped"} - }{ Replaces them with a higher rank's name. }
\item{\code{"drop"} - }{ Excludes them from the result. }
\item{\code{"asis"} - }{ To not check/modify any taxa names. }
}
Abbreviations are allowed. Default: \code{"singly"}}

\item{other}{Sum all non-itemized taxa into an "Other" taxa. When
\code{FALSE}, only returns taxa matched by the \code{taxa}
argument. Specifying \code{TRUE} adds "Other" to the returned set.
A string can also be given to imply \code{TRUE}, but with that
value as the name to use instead of "Other".
Default: \code{FALSE}}

\item{split.by}{Dataset field(s) that the data should be split by prior to
any calculations. Must be categorical. Default: \code{NULL}}

\item{transform}{Transformation to apply. Options are:
\code{c("none", "rank", "log", "log1p", "sqrt", "percent")}. \code{"rank"} is
useful for correcting for non-normally distributions before applying
regression statistics. Default: \code{"none"}}

\item{test}{Method for computing p-values: \code{'wilcox'}, \code{'kruskal'},
\code{'emmeans'}, or \code{'emtrends'}. Default: \code{'emmeans'}}

\item{fit}{How to fit the trendline. \code{'lm'}, \code{'log'}, or \code{'gam'}.
Default: \code{'gam'}}

\item{at}{Position(s) along the x-axis where the means or slopes should be
evaluated. Default: \code{NULL}, which samples 100 evenly spaced positions
and selects the position where the p-value is most significant.}

\item{level}{The confidence level for calculating a confidence interval.
Default: \code{0.95}}

\item{alt}{Alternative hypothesis direction. Options are \code{'!='}
(two-sided; not equal to \code{mu}), \code{'<'} (less than \code{mu}), or \code{'>'}
(greater than \code{mu}). Default: \code{'!='}}

\item{mu}{Reference value to test against. Default: \code{0}}

\item{p.adj}{Method to use for multiple comparisons adjustment of
p-values. Run \code{p.adjust.methods} for a list of available
options. Default: \code{"fdr"}}
}
\value{
A tibble data.frame with fields from the table below. This tibble
object provides the \verb{$code} operator to print the R code used to generate
the statistics.\tabular{ll}{
   \strong{Field} \tab \strong{Description} \cr
   .mean \tab Estimated marginal mean. See \code{\link[emmeans:emmeans]{emmeans::emmeans()}}. \cr
   .mean.diff \tab Difference in means. \cr
   .slope \tab Trendline slope. See \code{\link[emmeans:emtrends]{emmeans::emtrends()}}. \cr
   .slope.diff \tab Difference in slopes. \cr
   .h1 \tab Alternate hypothesis. \cr
   .p.val \tab Probability that null hypothesis is correct. \cr
   .adj.p \tab \code{.p.val} after adjusting for multiple comparisons. \cr
   .effect.size \tab Effect size. See \code{\link[emmeans:eff_size]{emmeans::eff_size()}}. \cr
   .lower \tab Confidence interval lower bound. \cr
   .upper \tab Confidence interval upper bound. \cr
   .se \tab Standard error. \cr
   .n \tab Number of samples. \cr
   .df \tab Degrees of freedom. \cr
   .stat \tab Wilcoxon or Kruskal-Wallis rank sum statistic. \cr
   .t.ratio \tab \code{.mean} / \code{.se} \cr
   .r.sqr \tab Percent of variation explained by the model. \cr
   .adj.r \tab \code{.r.sqr}, taking degrees of freedom into account. \cr
   .aic \tab Akaike Information Criterion (predictive models). \cr
   .bic \tab Bayesian Information Criterion (descriptive models). \cr
   .loglik \tab Log-likelihood goodness-of-fit score. \cr
   .fit.p \tab P-value for observing this fit by chance. \cr
}
}
\description{
A convenience wrapper for \code{\link[=taxa_table]{taxa_table()}} + \code{\link[=stats_table]{stats_table()}}.
}
\examples{
    library(rbiom)
    
    biom <- rarefy(hmp50)
    
    taxa_stats(biom, stat.by = "Body Site", rank = "Family")[,1:6]
}
\seealso{
Other taxa_abundance: 
\code{\link{sample_sums}()},
\code{\link{taxa_boxplot}()},
\code{\link{taxa_clusters}()},
\code{\link{taxa_corrplot}()},
\code{\link{taxa_heatmap}()},
\code{\link{taxa_stacked}()},
\code{\link{taxa_sums}()},
\code{\link{taxa_table}()}

Other stats_tables: 
\code{\link{adiv_stats}()},
\code{\link{bdiv_stats}()},
\code{\link{distmat_stats}()},
\code{\link{stats_table}()}
}
\concept{stats_tables}
\concept{taxa_abundance}
