// Generated by rstantools.  Do not edit by hand.

/*
    rbioacc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rbioacc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rbioacc.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_odeTK_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_odeTK");
    reader.add_event(2, 2, "include", "/include/linear_interpolation.stan");
    reader.add_event(2, 0, "start", "/include/linear_interpolation.stan");
    reader.add_event(125, 123, "end", "/include/linear_interpolation.stan");
    reader.add_event(125, 3, "restart", "model_odeTK");
    reader.add_event(330, 206, "end", "model_odeTK");
    return reader;
}
template <typename T0__, typename T1__>
int
findfirst(const T0__& t,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xt, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 5;
        int i(0);
        (void) i;  // dummy to suppress unused var warning
        stan::math::fill(i, std::numeric_limits<int>::min());
        stan::math::assign(i,0);
        current_statement_begin__ = 6;
        if (as_bool(logical_eq(t, max(xt)))) {
            current_statement_begin__ = 7;
            stan::math::assign(i, (num_elements(xt) - 1));
            current_statement_begin__ = 8;
            return stan::math::promote_scalar<fun_return_scalar_t__>(i);
        } else if (as_bool((primitive_value(logical_lt(t, min(xt))) || primitive_value(logical_gt(t, max(xt)))))) {
            current_statement_begin__ = 10;
            return stan::math::promote_scalar<fun_return_scalar_t__>(i);
        } else {
            current_statement_begin__ = 12;
            while (as_bool(logical_gte(t, get_base1(xt, (i + 1), "xt", 1)))) {
                current_statement_begin__ = 13;
                stan::math::assign(i, (i + 1));
            }
            current_statement_begin__ = 15;
            return stan::math::promote_scalar<fun_return_scalar_t__>(i);
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct findfirst_functor__ {
    template <typename T0__, typename T1__>
        int
    operator()(const T0__& t,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xt, std::ostream* pstream__) const {
        return findfirst(t, xt, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
interpolate(const T0__& x,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xpt,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& ypt, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 20;
        if (as_bool((primitive_value(logical_gte(x, min(xpt))) && primitive_value(logical_lte(x, max(xpt)))))) {
            {
            current_statement_begin__ = 21;
            int idx(0);
            (void) idx;  // dummy to suppress unused var warning
            stan::math::fill(idx, std::numeric_limits<int>::min());
            stan::math::assign(idx,findfirst(x, xpt, pstream__));
            current_statement_begin__ = 22;
            return stan::math::promote_scalar<fun_return_scalar_t__>((get_base1(ypt, idx, "ypt", 1) + (((x - get_base1(xpt, idx, "xpt", 1)) * (get_base1(ypt, (idx + 1), "ypt", 1) - get_base1(ypt, idx, "ypt", 1))) / (get_base1(xpt, (idx + 1), "xpt", 1) - get_base1(xpt, idx, "xpt", 1)))));
            }
        } else {
            current_statement_begin__ = 24;
            return stan::math::promote_scalar<fun_return_scalar_t__>(0.0);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct interpolate_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& x,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xpt,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& ypt, std::ostream* pstream__) const {
        return interpolate(x, xpt, ypt, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
odeTK(const T0__& t,
          const std::vector<T1__>& y,
          const std::vector<T2__>& theta,
          const std::vector<T3__>& x_r,
          const std::vector<int>& x_i, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 37;
        int lentp_rmNA(0);
        (void) lentp_rmNA;  // dummy to suppress unused var warning
        stan::math::fill(lentp_rmNA, std::numeric_limits<int>::min());
        stan::math::assign(lentp_rmNA,get_base1(x_i, 1, "x_i", 1));
        current_statement_begin__ = 38;
        int lentp(0);
        (void) lentp;  // dummy to suppress unused var warning
        stan::math::fill(lentp, std::numeric_limits<int>::min());
        stan::math::assign(lentp,get_base1(x_i, 2, "x_i", 1));
        current_statement_begin__ = 39;
        int n_exp(0);
        (void) n_exp;  // dummy to suppress unused var warning
        stan::math::fill(n_exp, std::numeric_limits<int>::min());
        stan::math::assign(n_exp,get_base1(x_i, 3, "x_i", 1));
        current_statement_begin__ = 40;
        int n_out(0);
        (void) n_out;  // dummy to suppress unused var warning
        stan::math::fill(n_out, std::numeric_limits<int>::min());
        stan::math::assign(n_out,get_base1(x_i, 4, "x_i", 1));
        current_statement_begin__ = 41;
        int n_met(0);
        (void) n_met;  // dummy to suppress unused var warning
        stan::math::fill(n_met, std::numeric_limits<int>::min());
        stan::math::assign(n_met,get_base1(x_i, 5, "x_i", 1));
        current_statement_begin__ = 43;
        validate_non_negative_index("ku", "n_exp", n_exp);
        std::vector<local_scalar_t__  > ku(n_exp, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(ku, DUMMY_VAR__);
        stan::math::fill(ku, DUMMY_VAR__);
        stan::math::assign(ku,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max(1, n_exp), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 44;
        validate_non_negative_index("ke", "n_out", n_out);
        std::vector<local_scalar_t__  > ke(n_out, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(ke, DUMMY_VAR__);
        stan::math::fill(ke, DUMMY_VAR__);
        stan::math::assign(ke,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max((n_exp + 1), (n_exp + n_out)), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 45;
        validate_non_negative_index("km", "n_met", n_met);
        std::vector<local_scalar_t__  > km(n_met, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(km, DUMMY_VAR__);
        stan::math::fill(km, DUMMY_VAR__);
        stan::math::assign(km,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max(((n_exp + n_out) + 1), ((n_exp + n_out) + n_met)), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 46;
        validate_non_negative_index("kem", "n_met", n_met);
        std::vector<local_scalar_t__  > kem(n_met, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(kem, DUMMY_VAR__);
        stan::math::fill(kem, DUMMY_VAR__);
        stan::math::assign(kem,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max((((n_exp + n_out) + n_met) + 1), (((n_exp + n_out) + n_met) + n_met)), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 49;
        validate_non_negative_index("dydt", "(1 + n_met)", (1 + n_met));
        std::vector<local_scalar_t__  > dydt((1 + n_met), local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(dydt, DUMMY_VAR__);
        stan::math::fill(dydt, DUMMY_VAR__);
        current_statement_begin__ = 51;
        local_scalar_t__ tacc(DUMMY_VAR__);
        (void) tacc;  // dummy to suppress unused var warning
        stan::math::initialize(tacc, DUMMY_VAR__);
        stan::math::fill(tacc, DUMMY_VAR__);
        stan::math::assign(tacc,get_base1(x_r, 1, "x_r", 1));
        current_statement_begin__ = 53;
        validate_non_negative_index("tp_rmNA", "lentp_rmNA", lentp_rmNA);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tp_rmNA(lentp_rmNA);
        stan::math::initialize(tp_rmNA, DUMMY_VAR__);
        stan::math::fill(tp_rmNA, DUMMY_VAR__);
        stan::math::assign(tp_rmNA,to_vector(stan::model::rvalue(x_r, stan::model::cons_list(stan::model::index_min_max(2, (lentp_rmNA + 1)), stan::model::nil_index_list()), "x_r")));
        current_statement_begin__ = 57;
        validate_non_negative_index("Cexp_rmNA", "lentp_rmNA", lentp_rmNA);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Cexp_rmNA(lentp_rmNA);
        stan::math::initialize(Cexp_rmNA, DUMMY_VAR__);
        stan::math::fill(Cexp_rmNA, DUMMY_VAR__);
        stan::math::assign(Cexp_rmNA,to_vector(stan::model::rvalue(x_r, stan::model::cons_list(stan::model::index_min_max((lentp_rmNA + 2), ((lentp_rmNA + 1) + lentp_rmNA)), stan::model::nil_index_list()), "x_r")));
        current_statement_begin__ = 60;
        local_scalar_t__ U(DUMMY_VAR__);
        (void) U;  // dummy to suppress unused var warning
        stan::math::initialize(U, DUMMY_VAR__);
        stan::math::fill(U, DUMMY_VAR__);
        current_statement_begin__ = 61;
        local_scalar_t__ M(DUMMY_VAR__);
        (void) M;  // dummy to suppress unused var warning
        stan::math::initialize(M, DUMMY_VAR__);
        stan::math::fill(M, DUMMY_VAR__);
        current_statement_begin__ = 62;
        local_scalar_t__ E(DUMMY_VAR__);
        (void) E;  // dummy to suppress unused var warning
        stan::math::initialize(E, DUMMY_VAR__);
        stan::math::fill(E, DUMMY_VAR__);
        current_statement_begin__ = 64;
        if (as_bool(logical_eq(n_met, 0))) {
            current_statement_begin__ = 65;
            stan::math::assign(M, 0);
        } else {
            current_statement_begin__ = 67;
            stan::math::assign(M, sum(km));
        }
        current_statement_begin__ = 69;
        stan::math::assign(E, sum(ke));
        current_statement_begin__ = 73;
        stan::math::assign(U, (get_base1(ku, 1, "ku", 1) * interpolate(t, tp_rmNA, Cexp_rmNA, pstream__)));
        current_statement_begin__ = 79;
        if (as_bool(logical_lte(t, tacc))) {
            current_statement_begin__ = 81;
            stan::model::assign(dydt, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (U - ((E + M) * get_base1(y, 1, "y", 1))), 
                        "assigning variable dydt");
        } else {
            current_statement_begin__ = 84;
            stan::model::assign(dydt, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (-((E + M)) * get_base1(y, 1, "y", 1)), 
                        "assigning variable dydt");
        }
        current_statement_begin__ = 86;
        if (as_bool(logical_gt(n_met, 0))) {
            current_statement_begin__ = 87;
            for (int i = 2; i <= (n_met + 1); ++i) {
                current_statement_begin__ = 88;
                stan::model::assign(dydt, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((get_base1(km, i, "km", 1) * get_base1(y, 1, "y", 1)) - (get_base1(kem, i, "kem", 1) * get_base1(y, i, "y", 1))), 
                            "assigning variable dydt");
            }
        }
        current_statement_begin__ = 91;
        return stan::math::promote_scalar<fun_return_scalar_t__>(dydt);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct odeTK_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& t,
          const std::vector<T1__>& y,
          const std::vector<T2__>& theta,
          const std::vector<T3__>& x_r,
          const std::vector<int>& x_i, std::ostream* pstream__) const {
        return odeTK(t, y, theta, x_r, x_i, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_odeTK
  : public stan::model::model_base_crtp<model_odeTK> {
private:
        int n_rep;
        int lentp;
        std::vector<double> tp;
        int n_exp;
        int lentp_rmNA;
        vector_d tp_rmNA;
        matrix_d Cexp_rmNA;
        int n_out;
        std::vector<std::vector<std::vector<double> > > CGobs;
        int n_met;
        std::vector<std::vector<std::vector<double> > > Cmet;
        double gmaxsup;
        int rankacc;
        double tacc;
        double C0;
        double unifMax;
        int len_vt;
        vector_d vt;
        std::vector<double> y0;
        double t0;
        std::vector<double> x_r;
        std::vector<int> x_int;
public:
    model_odeTK(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_odeTK(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_odeTK_namespace::model_odeTK";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 131;
            context__.validate_dims("data initialization", "n_rep", "int", context__.to_vec());
            n_rep = int(0);
            vals_i__ = context__.vals_i("n_rep");
            pos__ = 0;
            n_rep = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_rep", n_rep, 0);
            current_statement_begin__ = 134;
            context__.validate_dims("data initialization", "lentp", "int", context__.to_vec());
            lentp = int(0);
            vals_i__ = context__.vals_i("lentp");
            pos__ = 0;
            lentp = vals_i__[pos__++];
            check_greater_or_equal(function__, "lentp", lentp, 0);
            current_statement_begin__ = 135;
            validate_non_negative_index("tp", "lentp", lentp);
            context__.validate_dims("data initialization", "tp", "double", context__.to_vec(lentp));
            tp = std::vector<double>(lentp, double(0));
            vals_r__ = context__.vals_r("tp");
            pos__ = 0;
            size_t tp_k_0_max__ = lentp;
            for (size_t k_0__ = 0; k_0__ < tp_k_0_max__; ++k_0__) {
                tp[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 138;
            context__.validate_dims("data initialization", "n_exp", "int", context__.to_vec());
            n_exp = int(0);
            vals_i__ = context__.vals_i("n_exp");
            pos__ = 0;
            n_exp = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_exp", n_exp, 0);
            current_statement_begin__ = 139;
            context__.validate_dims("data initialization", "lentp_rmNA", "int", context__.to_vec());
            lentp_rmNA = int(0);
            vals_i__ = context__.vals_i("lentp_rmNA");
            pos__ = 0;
            lentp_rmNA = vals_i__[pos__++];
            check_greater_or_equal(function__, "lentp_rmNA", lentp_rmNA, 0);
            current_statement_begin__ = 140;
            validate_non_negative_index("tp_rmNA", "lentp_rmNA", lentp_rmNA);
            context__.validate_dims("data initialization", "tp_rmNA", "vector_d", context__.to_vec(lentp_rmNA));
            tp_rmNA = Eigen::Matrix<double, Eigen::Dynamic, 1>(lentp_rmNA);
            vals_r__ = context__.vals_r("tp_rmNA");
            pos__ = 0;
            size_t tp_rmNA_j_1_max__ = lentp_rmNA;
            for (size_t j_1__ = 0; j_1__ < tp_rmNA_j_1_max__; ++j_1__) {
                tp_rmNA(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 141;
            validate_non_negative_index("Cexp_rmNA", "lentp_rmNA", lentp_rmNA);
            validate_non_negative_index("Cexp_rmNA", "n_exp", n_exp);
            context__.validate_dims("data initialization", "Cexp_rmNA", "matrix_d", context__.to_vec(lentp_rmNA,n_exp));
            Cexp_rmNA = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(lentp_rmNA, n_exp);
            vals_r__ = context__.vals_r("Cexp_rmNA");
            pos__ = 0;
            size_t Cexp_rmNA_j_2_max__ = n_exp;
            size_t Cexp_rmNA_j_1_max__ = lentp_rmNA;
            for (size_t j_2__ = 0; j_2__ < Cexp_rmNA_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cexp_rmNA_j_1_max__; ++j_1__) {
                    Cexp_rmNA(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 145;
            context__.validate_dims("data initialization", "n_out", "int", context__.to_vec());
            n_out = int(0);
            vals_i__ = context__.vals_i("n_out");
            pos__ = 0;
            n_out = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_out", n_out, 0);
            current_statement_begin__ = 146;
            validate_non_negative_index("CGobs", "lentp", lentp);
            validate_non_negative_index("CGobs", "n_out", n_out);
            validate_non_negative_index("CGobs", "n_rep", n_rep);
            context__.validate_dims("data initialization", "CGobs", "double", context__.to_vec(lentp,n_out,n_rep));
            CGobs = std::vector<std::vector<std::vector<double> > >(lentp, std::vector<std::vector<double> >(n_out, std::vector<double>(n_rep, double(0))));
            vals_r__ = context__.vals_r("CGobs");
            pos__ = 0;
            size_t CGobs_k_0_max__ = lentp;
            size_t CGobs_k_1_max__ = n_out;
            size_t CGobs_k_2_max__ = n_rep;
            for (size_t k_2__ = 0; k_2__ < CGobs_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < CGobs_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < CGobs_k_0_max__; ++k_0__) {
                        CGobs[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                    }
                }
            }
            current_statement_begin__ = 149;
            context__.validate_dims("data initialization", "n_met", "int", context__.to_vec());
            n_met = int(0);
            vals_i__ = context__.vals_i("n_met");
            pos__ = 0;
            n_met = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_met", n_met, 0);
            current_statement_begin__ = 150;
            validate_non_negative_index("Cmet", "lentp", lentp);
            validate_non_negative_index("Cmet", "n_met", n_met);
            validate_non_negative_index("Cmet", "n_rep", n_rep);
            context__.validate_dims("data initialization", "Cmet", "double", context__.to_vec(lentp,n_met,n_rep));
            Cmet = std::vector<std::vector<std::vector<double> > >(lentp, std::vector<std::vector<double> >(n_met, std::vector<double>(n_rep, double(0))));
            vals_r__ = context__.vals_r("Cmet");
            pos__ = 0;
            size_t Cmet_k_0_max__ = lentp;
            size_t Cmet_k_1_max__ = n_met;
            size_t Cmet_k_2_max__ = n_rep;
            for (size_t k_2__ = 0; k_2__ < Cmet_k_2_max__; ++k_2__) {
                for (size_t k_1__ = 0; k_1__ < Cmet_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < Cmet_k_0_max__; ++k_0__) {
                        Cmet[k_0__][k_1__][k_2__] = vals_r__[pos__++];
                    }
                }
            }
            current_statement_begin__ = 155;
            context__.validate_dims("data initialization", "gmaxsup", "double", context__.to_vec());
            gmaxsup = double(0);
            vals_r__ = context__.vals_r("gmaxsup");
            pos__ = 0;
            gmaxsup = vals_r__[pos__++];
            check_greater_or_equal(function__, "gmaxsup", gmaxsup, 0);
            current_statement_begin__ = 158;
            context__.validate_dims("data initialization", "rankacc", "int", context__.to_vec());
            rankacc = int(0);
            vals_i__ = context__.vals_i("rankacc");
            pos__ = 0;
            rankacc = vals_i__[pos__++];
            check_greater_or_equal(function__, "rankacc", rankacc, 0);
            current_statement_begin__ = 159;
            context__.validate_dims("data initialization", "tacc", "double", context__.to_vec());
            tacc = double(0);
            vals_r__ = context__.vals_r("tacc");
            pos__ = 0;
            tacc = vals_r__[pos__++];
            check_greater_or_equal(function__, "tacc", tacc, 0);
            current_statement_begin__ = 160;
            context__.validate_dims("data initialization", "C0", "double", context__.to_vec());
            C0 = double(0);
            vals_r__ = context__.vals_r("C0");
            pos__ = 0;
            C0 = vals_r__[pos__++];
            check_greater_or_equal(function__, "C0", C0, 0);
            current_statement_begin__ = 162;
            context__.validate_dims("data initialization", "unifMax", "double", context__.to_vec());
            unifMax = double(0);
            vals_r__ = context__.vals_r("unifMax");
            pos__ = 0;
            unifMax = vals_r__[pos__++];
            current_statement_begin__ = 163;
            context__.validate_dims("data initialization", "len_vt", "int", context__.to_vec());
            len_vt = int(0);
            vals_i__ = context__.vals_i("len_vt");
            pos__ = 0;
            len_vt = vals_i__[pos__++];
            check_greater_or_equal(function__, "len_vt", len_vt, 0);
            current_statement_begin__ = 164;
            validate_non_negative_index("vt", "len_vt", len_vt);
            context__.validate_dims("data initialization", "vt", "vector_d", context__.to_vec(len_vt));
            vt = Eigen::Matrix<double, Eigen::Dynamic, 1>(len_vt);
            vals_r__ = context__.vals_r("vt");
            pos__ = 0;
            size_t vt_j_1_max__ = len_vt;
            for (size_t j_1__ = 0; j_1__ < vt_j_1_max__; ++j_1__) {
                vt(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 167;
            validate_non_negative_index("y0", "(1 + n_met)", (1 + n_met));
            context__.validate_dims("data initialization", "y0", "double", context__.to_vec((1 + n_met)));
            y0 = std::vector<double>((1 + n_met), double(0));
            vals_r__ = context__.vals_r("y0");
            pos__ = 0;
            size_t y0_k_0_max__ = (1 + n_met);
            for (size_t k_0__ = 0; k_0__ < y0_k_0_max__; ++k_0__) {
                y0[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 168;
            context__.validate_dims("data initialization", "t0", "double", context__.to_vec());
            t0 = double(0);
            vals_r__ = context__.vals_r("t0");
            pos__ = 0;
            t0 = vals_r__[pos__++];
            // initialize transformed data variables
            current_statement_begin__ = 175;
            validate_non_negative_index("x_r", "((1 + lentp_rmNA) + lentp_rmNA)", ((1 + lentp_rmNA) + lentp_rmNA));
            x_r = std::vector<double>(((1 + lentp_rmNA) + lentp_rmNA), double(0));
            stan::math::fill(x_r, DUMMY_VAR__);
            current_statement_begin__ = 176;
            validate_non_negative_index("x_int", "5", 5);
            x_int = std::vector<int>(5, int(0));
            stan::math::fill(x_int, std::numeric_limits<int>::min());
            // execute transformed data statements
            current_statement_begin__ = 178;
            stan::model::assign(x_r, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        tacc, 
                        "assigning variable x_r");
            current_statement_begin__ = 180;
            for (int i = 1; i <= lentp_rmNA; ++i) {
                current_statement_begin__ = 181;
                stan::model::assign(x_r, 
                            stan::model::cons_list(stan::model::index_uni((1 + i)), stan::model::nil_index_list()), 
                            get_base1(tp_rmNA, i, "tp_rmNA", 1), 
                            "assigning variable x_r");
            }
            current_statement_begin__ = 183;
            for (int i = 1; i <= lentp_rmNA; ++i) {
                current_statement_begin__ = 184;
                stan::model::assign(x_r, 
                            stan::model::cons_list(stan::model::index_uni(((i + lentp_rmNA) + 1)), stan::model::nil_index_list()), 
                            get_base1(Cexp_rmNA, i, 1, "Cexp_rmNA", 1), 
                            "assigning variable x_r");
            }
            current_statement_begin__ = 187;
            stan::model::assign(x_int, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        lentp_rmNA, 
                        "assigning variable x_int");
            current_statement_begin__ = 188;
            stan::model::assign(x_int, 
                        stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list()), 
                        lentp, 
                        "assigning variable x_int");
            current_statement_begin__ = 189;
            stan::model::assign(x_int, 
                        stan::model::cons_list(stan::model::index_uni(3), stan::model::nil_index_list()), 
                        n_exp, 
                        "assigning variable x_int");
            current_statement_begin__ = 190;
            stan::model::assign(x_int, 
                        stan::model::cons_list(stan::model::index_uni(4), stan::model::nil_index_list()), 
                        n_out, 
                        "assigning variable x_int");
            current_statement_begin__ = 191;
            stan::model::assign(x_int, 
                        stan::model::cons_list(stan::model::index_uni(5), stan::model::nil_index_list()), 
                        n_met, 
                        "assigning variable x_int");
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 195;
            validate_non_negative_index("log10ku", "n_exp", n_exp);
            num_params_r__ += n_exp;
            current_statement_begin__ = 196;
            validate_non_negative_index("log10ke", "n_out", n_out);
            num_params_r__ += n_out;
            current_statement_begin__ = 197;
            validate_non_negative_index("log10km", "n_met", n_met);
            num_params_r__ += n_met;
            current_statement_begin__ = 198;
            validate_non_negative_index("log10kem", "n_met", n_met);
            num_params_r__ += n_met;
            current_statement_begin__ = 200;
            validate_non_negative_index("sigmaCGpred", "n_out", n_out);
            num_params_r__ += (1 * n_out);
            current_statement_begin__ = 201;
            validate_non_negative_index("sigmaCmetpred", "n_met", n_met);
            num_params_r__ += n_met;
            current_statement_begin__ = 203;
            validate_non_negative_index("gmax", "(n_out - 1)", (n_out - 1));
            num_params_r__ += (1 * (n_out - 1));
            current_statement_begin__ = 204;
            validate_non_negative_index("G0", "(n_out - 1)", (n_out - 1));
            num_params_r__ += (1 * (n_out - 1));
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_odeTK() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 195;
        if (!(context__.contains_r("log10ku")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable log10ku missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("log10ku");
        pos__ = 0U;
        validate_non_negative_index("log10ku", "n_exp", n_exp);
        context__.validate_dims("parameter initialization", "log10ku", "vector_d", context__.to_vec(n_exp));
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10ku(n_exp);
        size_t log10ku_j_1_max__ = n_exp;
        for (size_t j_1__ = 0; j_1__ < log10ku_j_1_max__; ++j_1__) {
            log10ku(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(log10ku);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable log10ku: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 196;
        if (!(context__.contains_r("log10ke")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable log10ke missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("log10ke");
        pos__ = 0U;
        validate_non_negative_index("log10ke", "n_out", n_out);
        context__.validate_dims("parameter initialization", "log10ke", "vector_d", context__.to_vec(n_out));
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10ke(n_out);
        size_t log10ke_j_1_max__ = n_out;
        for (size_t j_1__ = 0; j_1__ < log10ke_j_1_max__; ++j_1__) {
            log10ke(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(log10ke);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable log10ke: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 197;
        if (!(context__.contains_r("log10km")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable log10km missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("log10km");
        pos__ = 0U;
        validate_non_negative_index("log10km", "n_met", n_met);
        context__.validate_dims("parameter initialization", "log10km", "vector_d", context__.to_vec(n_met));
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10km(n_met);
        size_t log10km_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10km_j_1_max__; ++j_1__) {
            log10km(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(log10km);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable log10km: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 198;
        if (!(context__.contains_r("log10kem")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable log10kem missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("log10kem");
        pos__ = 0U;
        validate_non_negative_index("log10kem", "n_met", n_met);
        context__.validate_dims("parameter initialization", "log10kem", "vector_d", context__.to_vec(n_met));
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10kem(n_met);
        size_t log10kem_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10kem_j_1_max__; ++j_1__) {
            log10kem(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_unconstrain(log10kem);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable log10kem: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 200;
        if (!(context__.contains_r("sigmaCGpred")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigmaCGpred missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigmaCGpred");
        pos__ = 0U;
        validate_non_negative_index("sigmaCGpred", "n_out", n_out);
        context__.validate_dims("parameter initialization", "sigmaCGpred", "double", context__.to_vec(n_out));
        std::vector<double> sigmaCGpred(n_out, double(0));
        size_t sigmaCGpred_k_0_max__ = n_out;
        for (size_t k_0__ = 0; k_0__ < sigmaCGpred_k_0_max__; ++k_0__) {
            sigmaCGpred[k_0__] = vals_r__[pos__++];
        }
        size_t sigmaCGpred_i_0_max__ = n_out;
        for (size_t i_0__ = 0; i_0__ < sigmaCGpred_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, sigmaCGpred[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigmaCGpred: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 201;
        if (!(context__.contains_r("sigmaCmetpred")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable sigmaCmetpred missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("sigmaCmetpred");
        pos__ = 0U;
        validate_non_negative_index("sigmaCmetpred", "n_met", n_met);
        context__.validate_dims("parameter initialization", "sigmaCmetpred", "vector_d", context__.to_vec(n_met));
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigmaCmetpred(n_met);
        size_t sigmaCmetpred_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < sigmaCmetpred_j_1_max__; ++j_1__) {
            sigmaCmetpred(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lb_unconstrain(0, sigmaCmetpred);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable sigmaCmetpred: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 203;
        if (!(context__.contains_r("gmax")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable gmax missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("gmax");
        pos__ = 0U;
        validate_non_negative_index("gmax", "(n_out - 1)", (n_out - 1));
        context__.validate_dims("parameter initialization", "gmax", "double", context__.to_vec((n_out - 1)));
        std::vector<double> gmax((n_out - 1), double(0));
        size_t gmax_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < gmax_k_0_max__; ++k_0__) {
            gmax[k_0__] = vals_r__[pos__++];
        }
        size_t gmax_i_0_max__ = (n_out - 1);
        for (size_t i_0__ = 0; i_0__ < gmax_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, gmax[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable gmax: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        current_statement_begin__ = 204;
        if (!(context__.contains_r("G0")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable G0 missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("G0");
        pos__ = 0U;
        validate_non_negative_index("G0", "(n_out - 1)", (n_out - 1));
        context__.validate_dims("parameter initialization", "G0", "double", context__.to_vec((n_out - 1)));
        std::vector<double> G0((n_out - 1), double(0));
        size_t G0_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < G0_k_0_max__; ++k_0__) {
            G0[k_0__] = vals_r__[pos__++];
        }
        size_t G0_i_0_max__ = (n_out - 1);
        for (size_t i_0__ = 0; i_0__ < G0_i_0_max__; ++i_0__) {
            try {
                writer__.scalar_lb_unconstrain(0, G0[i_0__]);
            } catch (const std::exception& e) {
                stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable G0: ") + e.what()), current_statement_begin__, prog_reader__());
            }
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 195;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log10ku;
            (void) log10ku;  // dummy to suppress unused var warning
            if (jacobian__)
                log10ku = in__.vector_constrain(n_exp, lp__);
            else
                log10ku = in__.vector_constrain(n_exp);
            current_statement_begin__ = 196;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log10ke;
            (void) log10ke;  // dummy to suppress unused var warning
            if (jacobian__)
                log10ke = in__.vector_constrain(n_out, lp__);
            else
                log10ke = in__.vector_constrain(n_out);
            current_statement_begin__ = 197;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log10km;
            (void) log10km;  // dummy to suppress unused var warning
            if (jacobian__)
                log10km = in__.vector_constrain(n_met, lp__);
            else
                log10km = in__.vector_constrain(n_met);
            current_statement_begin__ = 198;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> log10kem;
            (void) log10kem;  // dummy to suppress unused var warning
            if (jacobian__)
                log10kem = in__.vector_constrain(n_met, lp__);
            else
                log10kem = in__.vector_constrain(n_met);
            current_statement_begin__ = 200;
            std::vector<local_scalar_t__> sigmaCGpred;
            size_t sigmaCGpred_d_0_max__ = n_out;
            sigmaCGpred.reserve(sigmaCGpred_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < sigmaCGpred_d_0_max__; ++d_0__) {
                if (jacobian__)
                    sigmaCGpred.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    sigmaCGpred.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 201;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> sigmaCmetpred;
            (void) sigmaCmetpred;  // dummy to suppress unused var warning
            if (jacobian__)
                sigmaCmetpred = in__.vector_lb_constrain(0, n_met, lp__);
            else
                sigmaCmetpred = in__.vector_lb_constrain(0, n_met);
            current_statement_begin__ = 203;
            std::vector<local_scalar_t__> gmax;
            size_t gmax_d_0_max__ = (n_out - 1);
            gmax.reserve(gmax_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < gmax_d_0_max__; ++d_0__) {
                if (jacobian__)
                    gmax.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    gmax.push_back(in__.scalar_lb_constrain(0));
            }
            current_statement_begin__ = 204;
            std::vector<local_scalar_t__> G0;
            size_t G0_d_0_max__ = (n_out - 1);
            G0.reserve(G0_d_0_max__);
            for (size_t d_0__ = 0; d_0__ < G0_d_0_max__; ++d_0__) {
                if (jacobian__)
                    G0.push_back(in__.scalar_lb_constrain(0, lp__));
                else
                    G0.push_back(in__.scalar_lb_constrain(0));
            }
            // transformed parameters
            current_statement_begin__ = 209;
            validate_non_negative_index("ku", "n_exp", n_exp);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ku(n_exp);
            stan::math::initialize(ku, DUMMY_VAR__);
            stan::math::fill(ku, DUMMY_VAR__);
            current_statement_begin__ = 210;
            validate_non_negative_index("ke", "n_out", n_out);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> ke(n_out);
            stan::math::initialize(ke, DUMMY_VAR__);
            stan::math::fill(ke, DUMMY_VAR__);
            current_statement_begin__ = 211;
            validate_non_negative_index("km", "n_met", n_met);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> km(n_met);
            stan::math::initialize(km, DUMMY_VAR__);
            stan::math::fill(km, DUMMY_VAR__);
            current_statement_begin__ = 212;
            validate_non_negative_index("kem", "n_met", n_met);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> kem(n_met);
            stan::math::initialize(kem, DUMMY_VAR__);
            stan::math::fill(kem, DUMMY_VAR__);
            current_statement_begin__ = 215;
            validate_non_negative_index("Cexp", "lentp", lentp);
            validate_non_negative_index("Cexp", "n_exp", n_exp);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Cexp(lentp, n_exp);
            stan::math::initialize(Cexp, DUMMY_VAR__);
            stan::math::fill(Cexp, DUMMY_VAR__);
            current_statement_begin__ = 217;
            validate_non_negative_index("CGpred", "lentp", lentp);
            validate_non_negative_index("CGpred", "n_out", n_out);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> CGpred(lentp, n_out);
            stan::math::initialize(CGpred, DUMMY_VAR__);
            stan::math::fill(CGpred, DUMMY_VAR__);
            current_statement_begin__ = 218;
            validate_non_negative_index("Cmetpred", "lentp", lentp);
            validate_non_negative_index("Cmetpred", "n_met", n_met);
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> Cmetpred(lentp, n_met);
            stan::math::initialize(Cmetpred, DUMMY_VAR__);
            stan::math::fill(Cmetpred, DUMMY_VAR__);
            current_statement_begin__ = 223;
            validate_non_negative_index("y_sim", "lentp", lentp);
            validate_non_negative_index("y_sim", "(1 + n_met)", (1 + n_met));
            std::vector<std::vector<local_scalar_t__> > y_sim(lentp, std::vector<local_scalar_t__>((1 + n_met), local_scalar_t__(0)));
            stan::math::initialize(y_sim, DUMMY_VAR__);
            stan::math::fill(y_sim, DUMMY_VAR__);
            current_statement_begin__ = 226;
            validate_non_negative_index("theta", "(((n_exp + n_out) + n_met) + n_met)", (((n_exp + n_out) + n_met) + n_met));
            std::vector<local_scalar_t__> theta((((n_exp + n_out) + n_met) + n_met), local_scalar_t__(0));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            // transformed parameters block statements
            current_statement_begin__ = 228;
            for (int i = 1; i <= n_exp; ++i) {
                current_statement_begin__ = 229;
                stan::model::assign(ku, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10ku, i, "log10ku", 1)), 
                            "assigning variable ku");
            }
            current_statement_begin__ = 231;
            for (int i = 1; i <= n_out; ++i) {
                current_statement_begin__ = 232;
                stan::model::assign(ke, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10ke, i, "log10ke", 1)), 
                            "assigning variable ke");
            }
            current_statement_begin__ = 234;
            for (int i = 1; i <= n_met; ++i) {
                current_statement_begin__ = 235;
                stan::model::assign(km, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10km, i, "log10km", 1)), 
                            "assigning variable km");
                current_statement_begin__ = 236;
                stan::model::assign(kem, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10kem, i, "log10kem", 1)), 
                            "assigning variable kem");
            }
            current_statement_begin__ = 248;
            for (int i = 1; i <= n_exp; ++i) {
                current_statement_begin__ = 249;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            get_base1(ku, i, "ku", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 251;
            for (int i = 1; i <= n_out; ++i) {
                current_statement_begin__ = 252;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni((n_exp + i)), stan::model::nil_index_list()), 
                            get_base1(ke, i, "ke", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 254;
            for (int i = 1; i <= n_met; ++i) {
                current_statement_begin__ = 255;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(((n_exp + n_out) + i)), stan::model::nil_index_list()), 
                            get_base1(km, i, "km", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 257;
            for (int i = 1; i <= n_met; ++i) {
                current_statement_begin__ = 258;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni((((n_exp + n_out) + n_met) + i)), stan::model::nil_index_list()), 
                            get_base1(kem, i, "kem", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 261;
            stan::math::assign(y_sim, integrate_ode_rk45(odeTK_functor__(), y0, t0, tp, theta, x_r, x_int, pstream__));
            current_statement_begin__ = 265;
            for (int t = 1; t <= lentp; ++t) {
                current_statement_begin__ = 266;
                stan::model::assign(CGpred, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            get_base1(get_base1(y_sim, t, "y_sim", 1), 1, "y_sim", 2), 
                            "assigning variable CGpred");
                current_statement_begin__ = 267;
                for (int i = 1; i <= n_met; ++i) {
                    current_statement_begin__ = 268;
                    stan::model::assign(Cmetpred, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                get_base1(get_base1(y_sim, t, "y_sim", 1), (i + 1), "y_sim", 2), 
                                "assigning variable Cmetpred");
                }
            }
            current_statement_begin__ = 272;
            if (as_bool(logical_eq(n_out, 2))) {
                current_statement_begin__ = 273;
                for (int t = 1; t <= lentp; ++t) {
                    current_statement_begin__ = 274;
                    stan::model::assign(CGpred, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                                (((get_base1(G0, 1, "G0", 1) - get_base1(gmax, 1, "gmax", 1)) * stan::math::exp((-(get_base1(ke, 2, "ke", 1)) * get_base1(tp, t, "tp", 1)))) + get_base1(gmax, 1, "gmax", 1)), 
                                "assigning variable CGpred");
                }
            }
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 209;
            size_t ku_j_1_max__ = n_exp;
            for (size_t j_1__ = 0; j_1__ < ku_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ku(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ku" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ku: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "ku", ku, 0);
            current_statement_begin__ = 210;
            size_t ke_j_1_max__ = n_out;
            for (size_t j_1__ = 0; j_1__ < ke_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(ke(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ke" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable ke: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "ke", ke, 0);
            current_statement_begin__ = 211;
            size_t km_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < km_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(km(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: km" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable km: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "km", km, 0);
            current_statement_begin__ = 212;
            size_t kem_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < kem_j_1_max__; ++j_1__) {
                if (stan::math::is_uninitialized(kem(j_1__))) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: kem" << "(" << j_1__ << ")";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable kem: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            check_greater_or_equal(function__, "kem", kem, 0);
            current_statement_begin__ = 215;
            size_t Cexp_j_1_max__ = lentp;
            size_t Cexp_j_2_max__ = n_exp;
            for (size_t j_1__ = 0; j_1__ < Cexp_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Cexp_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Cexp(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Cexp" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Cexp: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 217;
            size_t CGpred_j_1_max__ = lentp;
            size_t CGpred_j_2_max__ = n_out;
            for (size_t j_1__ = 0; j_1__ < CGpred_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < CGpred_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(CGpred(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: CGpred" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable CGpred: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 218;
            size_t Cmetpred_j_1_max__ = lentp;
            size_t Cmetpred_j_2_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < Cmetpred_j_1_max__; ++j_1__) {
                for (size_t j_2__ = 0; j_2__ < Cmetpred_j_2_max__; ++j_2__) {
                    if (stan::math::is_uninitialized(Cmetpred(j_1__, j_2__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: Cmetpred" << "(" << j_1__ << ", " << j_2__ << ")";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable Cmetpred: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 223;
            size_t y_sim_k_0_max__ = lentp;
            size_t y_sim_k_1_max__ = (1 + n_met);
            for (size_t k_0__ = 0; k_0__ < y_sim_k_0_max__; ++k_0__) {
                for (size_t k_1__ = 0; k_1__ < y_sim_k_1_max__; ++k_1__) {
                    if (stan::math::is_uninitialized(y_sim[k_0__][k_1__])) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: y_sim" << "[" << k_0__ << "]" << "[" << k_1__ << "]";
                        stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable y_sim: ") + msg__.str()), current_statement_begin__, prog_reader__());
                    }
                }
            }
            current_statement_begin__ = 226;
            size_t theta_k_0_max__ = (((n_exp + n_out) + n_met) + n_met);
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                if (stan::math::is_uninitialized(theta[k_0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: theta" << "[" << k_0__ << "]";
                    stan::lang::rethrow_located(std::runtime_error(std::string("Error initializing variable theta: ") + msg__.str()), current_statement_begin__, prog_reader__());
                }
            }
            // model body
            current_statement_begin__ = 280;
            lp_accum__.add(uniform_log(log10ku, -(5), 5));
            current_statement_begin__ = 281;
            lp_accum__.add(uniform_log(log10ke, -(5), 5));
            current_statement_begin__ = 282;
            lp_accum__.add(uniform_log(log10km, -(5), 5));
            current_statement_begin__ = 283;
            lp_accum__.add(uniform_log(log10kem, -(5), 5));
            current_statement_begin__ = 284;
            lp_accum__.add(uniform_log(get_base1(sigmaCGpred, 1, "sigmaCGpred", 1), 0, unifMax));
            current_statement_begin__ = 285;
            lp_accum__.add(uniform_log(sigmaCmetpred, 0, unifMax));
            current_statement_begin__ = 286;
            if (as_bool(logical_eq(n_out, 2))) {
                current_statement_begin__ = 287;
                lp_accum__.add(uniform_log(get_base1(sigmaCGpred, 2, "sigmaCGpred", 1), 0, unifMax));
                current_statement_begin__ = 288;
                lp_accum__.add(uniform_log(get_base1(gmax, 1, "gmax", 1), (gmaxsup / 6), gmaxsup));
                current_statement_begin__ = 289;
                lp_accum__.add(uniform_log(get_base1(G0, 1, "G0", 1), 0, gmaxsup));
            }
            current_statement_begin__ = 292;
            for (int rep = 1; rep <= n_rep; ++rep) {
                current_statement_begin__ = 294;
                for (int t = 1; t <= rankacc; ++t) {
                    current_statement_begin__ = 296;
                    if (as_bool(logical_negation(is_inf(get_base1(get_base1(get_base1(CGobs, t, "CGobs", 1), 1, "CGobs", 2), rep, "CGobs", 3))))) {
                        current_statement_begin__ = 297;
                        lp_accum__.add(normal_log(get_base1(get_base1(get_base1(CGobs, t, "CGobs", 1), 1, "CGobs", 2), rep, "CGobs", 3), get_base1(CGpred, t, 1, "CGpred", 1), get_base1(sigmaCGpred, 1, "sigmaCGpred", 1)));
                    }
                    current_statement_begin__ = 300;
                    for (int i = 1; i <= n_met; ++i) {
                        current_statement_begin__ = 301;
                        if (as_bool(logical_negation(is_inf(get_base1(get_base1(get_base1(Cmet, t, "Cmet", 1), i, "Cmet", 2), rep, "Cmet", 3))))) {
                            current_statement_begin__ = 302;
                            lp_accum__.add(normal_log(get_base1(get_base1(get_base1(Cmet, t, "Cmet", 1), i, "Cmet", 2), rep, "Cmet", 3), get_base1(Cmetpred, t, i, "Cmetpred", 1), get_base1(sigmaCmetpred, i, "sigmaCmetpred", 1)));
                        }
                    }
                }
                current_statement_begin__ = 307;
                for (int t = (rankacc + 1); t <= lentp; ++t) {
                    current_statement_begin__ = 309;
                    if (as_bool(logical_negation(is_inf(get_base1(get_base1(get_base1(CGobs, t, "CGobs", 1), 1, "CGobs", 2), rep, "CGobs", 3))))) {
                        current_statement_begin__ = 310;
                        lp_accum__.add(normal_log(get_base1(get_base1(get_base1(CGobs, t, "CGobs", 1), 1, "CGobs", 2), rep, "CGobs", 3), get_base1(CGpred, t, 1, "CGpred", 1), get_base1(sigmaCGpred, 1, "sigmaCGpred", 1)));
                    }
                    current_statement_begin__ = 313;
                    for (int i = 1; i <= n_met; ++i) {
                        current_statement_begin__ = 314;
                        if (as_bool(logical_negation(is_inf(get_base1(get_base1(get_base1(Cmet, t, "Cmet", 1), i, "Cmet", 2), rep, "Cmet", 3))))) {
                            current_statement_begin__ = 315;
                            lp_accum__.add(normal_log(get_base1(get_base1(get_base1(Cmet, t, "Cmet", 1), i, "Cmet", 2), rep, "Cmet", 3), get_base1(Cmetpred, t, i, "Cmetpred", 1), get_base1(sigmaCmetpred, i, "sigmaCmetpred", 1)));
                        }
                    }
                }
                current_statement_begin__ = 320;
                if (as_bool(logical_eq(n_out, 2))) {
                    current_statement_begin__ = 321;
                    for (int t = 1; t <= lentp; ++t) {
                        current_statement_begin__ = 322;
                        if (as_bool(logical_negation(is_inf(get_base1(get_base1(get_base1(CGobs, t, "CGobs", 1), 2, "CGobs", 2), rep, "CGobs", 3))))) {
                            current_statement_begin__ = 323;
                            lp_accum__.add(normal_log(get_base1(get_base1(get_base1(CGobs, t, "CGobs", 1), 2, "CGobs", 2), rep, "CGobs", 3), get_base1(CGpred, t, 2, "CGpred", 1), get_base1(sigmaCGpred, 2, "sigmaCGpred", 1)));
                        }
                    }
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("log10ku");
        names__.push_back("log10ke");
        names__.push_back("log10km");
        names__.push_back("log10kem");
        names__.push_back("sigmaCGpred");
        names__.push_back("sigmaCmetpred");
        names__.push_back("gmax");
        names__.push_back("G0");
        names__.push_back("ku");
        names__.push_back("ke");
        names__.push_back("km");
        names__.push_back("kem");
        names__.push_back("Cexp");
        names__.push_back("CGpred");
        names__.push_back("Cmetpred");
        names__.push_back("y_sim");
        names__.push_back("theta");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_exp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_out);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_out);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((n_out - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((n_out - 1));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_exp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_out);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_exp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_out);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back((1 + n_met));
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back((((n_exp + n_out) + n_met) + n_met));
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_odeTK_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10ku = in__.vector_constrain(n_exp);
        size_t log10ku_j_1_max__ = n_exp;
        for (size_t j_1__ = 0; j_1__ < log10ku_j_1_max__; ++j_1__) {
            vars__.push_back(log10ku(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10ke = in__.vector_constrain(n_out);
        size_t log10ke_j_1_max__ = n_out;
        for (size_t j_1__ = 0; j_1__ < log10ke_j_1_max__; ++j_1__) {
            vars__.push_back(log10ke(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10km = in__.vector_constrain(n_met);
        size_t log10km_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10km_j_1_max__; ++j_1__) {
            vars__.push_back(log10km(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> log10kem = in__.vector_constrain(n_met);
        size_t log10kem_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10kem_j_1_max__; ++j_1__) {
            vars__.push_back(log10kem(j_1__));
        }
        std::vector<double> sigmaCGpred;
        size_t sigmaCGpred_d_0_max__ = n_out;
        sigmaCGpred.reserve(sigmaCGpred_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < sigmaCGpred_d_0_max__; ++d_0__) {
            sigmaCGpred.push_back(in__.scalar_lb_constrain(0));
        }
        size_t sigmaCGpred_k_0_max__ = n_out;
        for (size_t k_0__ = 0; k_0__ < sigmaCGpred_k_0_max__; ++k_0__) {
            vars__.push_back(sigmaCGpred[k_0__]);
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> sigmaCmetpred = in__.vector_lb_constrain(0, n_met);
        size_t sigmaCmetpred_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < sigmaCmetpred_j_1_max__; ++j_1__) {
            vars__.push_back(sigmaCmetpred(j_1__));
        }
        std::vector<double> gmax;
        size_t gmax_d_0_max__ = (n_out - 1);
        gmax.reserve(gmax_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < gmax_d_0_max__; ++d_0__) {
            gmax.push_back(in__.scalar_lb_constrain(0));
        }
        size_t gmax_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < gmax_k_0_max__; ++k_0__) {
            vars__.push_back(gmax[k_0__]);
        }
        std::vector<double> G0;
        size_t G0_d_0_max__ = (n_out - 1);
        G0.reserve(G0_d_0_max__);
        for (size_t d_0__ = 0; d_0__ < G0_d_0_max__; ++d_0__) {
            G0.push_back(in__.scalar_lb_constrain(0));
        }
        size_t G0_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < G0_k_0_max__; ++k_0__) {
            vars__.push_back(G0[k_0__]);
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            // declare and define transformed parameters
            current_statement_begin__ = 209;
            validate_non_negative_index("ku", "n_exp", n_exp);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ku(n_exp);
            stan::math::initialize(ku, DUMMY_VAR__);
            stan::math::fill(ku, DUMMY_VAR__);
            current_statement_begin__ = 210;
            validate_non_negative_index("ke", "n_out", n_out);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ke(n_out);
            stan::math::initialize(ke, DUMMY_VAR__);
            stan::math::fill(ke, DUMMY_VAR__);
            current_statement_begin__ = 211;
            validate_non_negative_index("km", "n_met", n_met);
            Eigen::Matrix<double, Eigen::Dynamic, 1> km(n_met);
            stan::math::initialize(km, DUMMY_VAR__);
            stan::math::fill(km, DUMMY_VAR__);
            current_statement_begin__ = 212;
            validate_non_negative_index("kem", "n_met", n_met);
            Eigen::Matrix<double, Eigen::Dynamic, 1> kem(n_met);
            stan::math::initialize(kem, DUMMY_VAR__);
            stan::math::fill(kem, DUMMY_VAR__);
            current_statement_begin__ = 215;
            validate_non_negative_index("Cexp", "lentp", lentp);
            validate_non_negative_index("Cexp", "n_exp", n_exp);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cexp(lentp, n_exp);
            stan::math::initialize(Cexp, DUMMY_VAR__);
            stan::math::fill(Cexp, DUMMY_VAR__);
            current_statement_begin__ = 217;
            validate_non_negative_index("CGpred", "lentp", lentp);
            validate_non_negative_index("CGpred", "n_out", n_out);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> CGpred(lentp, n_out);
            stan::math::initialize(CGpred, DUMMY_VAR__);
            stan::math::fill(CGpred, DUMMY_VAR__);
            current_statement_begin__ = 218;
            validate_non_negative_index("Cmetpred", "lentp", lentp);
            validate_non_negative_index("Cmetpred", "n_met", n_met);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cmetpred(lentp, n_met);
            stan::math::initialize(Cmetpred, DUMMY_VAR__);
            stan::math::fill(Cmetpred, DUMMY_VAR__);
            current_statement_begin__ = 223;
            validate_non_negative_index("y_sim", "lentp", lentp);
            validate_non_negative_index("y_sim", "(1 + n_met)", (1 + n_met));
            std::vector<std::vector<double> > y_sim(lentp, std::vector<double>((1 + n_met), double(0)));
            stan::math::initialize(y_sim, DUMMY_VAR__);
            stan::math::fill(y_sim, DUMMY_VAR__);
            current_statement_begin__ = 226;
            validate_non_negative_index("theta", "(((n_exp + n_out) + n_met) + n_met)", (((n_exp + n_out) + n_met) + n_met));
            std::vector<double> theta((((n_exp + n_out) + n_met) + n_met), double(0));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta, DUMMY_VAR__);
            // do transformed parameters statements
            current_statement_begin__ = 228;
            for (int i = 1; i <= n_exp; ++i) {
                current_statement_begin__ = 229;
                stan::model::assign(ku, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10ku, i, "log10ku", 1)), 
                            "assigning variable ku");
            }
            current_statement_begin__ = 231;
            for (int i = 1; i <= n_out; ++i) {
                current_statement_begin__ = 232;
                stan::model::assign(ke, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10ke, i, "log10ke", 1)), 
                            "assigning variable ke");
            }
            current_statement_begin__ = 234;
            for (int i = 1; i <= n_met; ++i) {
                current_statement_begin__ = 235;
                stan::model::assign(km, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10km, i, "log10km", 1)), 
                            "assigning variable km");
                current_statement_begin__ = 236;
                stan::model::assign(kem, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            pow(10, get_base1(log10kem, i, "log10kem", 1)), 
                            "assigning variable kem");
            }
            current_statement_begin__ = 248;
            for (int i = 1; i <= n_exp; ++i) {
                current_statement_begin__ = 249;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            get_base1(ku, i, "ku", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 251;
            for (int i = 1; i <= n_out; ++i) {
                current_statement_begin__ = 252;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni((n_exp + i)), stan::model::nil_index_list()), 
                            get_base1(ke, i, "ke", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 254;
            for (int i = 1; i <= n_met; ++i) {
                current_statement_begin__ = 255;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni(((n_exp + n_out) + i)), stan::model::nil_index_list()), 
                            get_base1(km, i, "km", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 257;
            for (int i = 1; i <= n_met; ++i) {
                current_statement_begin__ = 258;
                stan::model::assign(theta, 
                            stan::model::cons_list(stan::model::index_uni((((n_exp + n_out) + n_met) + i)), stan::model::nil_index_list()), 
                            get_base1(kem, i, "kem", 1), 
                            "assigning variable theta");
            }
            current_statement_begin__ = 261;
            stan::math::assign(y_sim, integrate_ode_rk45(odeTK_functor__(), y0, t0, tp, theta, x_r, x_int, pstream__));
            current_statement_begin__ = 265;
            for (int t = 1; t <= lentp; ++t) {
                current_statement_begin__ = 266;
                stan::model::assign(CGpred, 
                            stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                            get_base1(get_base1(y_sim, t, "y_sim", 1), 1, "y_sim", 2), 
                            "assigning variable CGpred");
                current_statement_begin__ = 267;
                for (int i = 1; i <= n_met; ++i) {
                    current_statement_begin__ = 268;
                    stan::model::assign(Cmetpred, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                get_base1(get_base1(y_sim, t, "y_sim", 1), (i + 1), "y_sim", 2), 
                                "assigning variable Cmetpred");
                }
            }
            current_statement_begin__ = 272;
            if (as_bool(logical_eq(n_out, 2))) {
                current_statement_begin__ = 273;
                for (int t = 1; t <= lentp; ++t) {
                    current_statement_begin__ = 274;
                    stan::model::assign(CGpred, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                                (((get_base1(G0, 1, "G0", 1) - get_base1(gmax, 1, "gmax", 1)) * stan::math::exp((-(get_base1(ke, 2, "ke", 1)) * get_base1(tp, t, "tp", 1)))) + get_base1(gmax, 1, "gmax", 1)), 
                                "assigning variable CGpred");
                }
            }
            if (!include_gqs__ && !include_tparams__) return;
            // validate transformed parameters
            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 209;
            check_greater_or_equal(function__, "ku", ku, 0);
            current_statement_begin__ = 210;
            check_greater_or_equal(function__, "ke", ke, 0);
            current_statement_begin__ = 211;
            check_greater_or_equal(function__, "km", km, 0);
            current_statement_begin__ = 212;
            check_greater_or_equal(function__, "kem", kem, 0);
            // write transformed parameters
            if (include_tparams__) {
                size_t ku_j_1_max__ = n_exp;
                for (size_t j_1__ = 0; j_1__ < ku_j_1_max__; ++j_1__) {
                    vars__.push_back(ku(j_1__));
                }
                size_t ke_j_1_max__ = n_out;
                for (size_t j_1__ = 0; j_1__ < ke_j_1_max__; ++j_1__) {
                    vars__.push_back(ke(j_1__));
                }
                size_t km_j_1_max__ = n_met;
                for (size_t j_1__ = 0; j_1__ < km_j_1_max__; ++j_1__) {
                    vars__.push_back(km(j_1__));
                }
                size_t kem_j_1_max__ = n_met;
                for (size_t j_1__ = 0; j_1__ < kem_j_1_max__; ++j_1__) {
                    vars__.push_back(kem(j_1__));
                }
                size_t Cexp_j_2_max__ = n_exp;
                size_t Cexp_j_1_max__ = lentp;
                for (size_t j_2__ = 0; j_2__ < Cexp_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Cexp_j_1_max__; ++j_1__) {
                        vars__.push_back(Cexp(j_1__, j_2__));
                    }
                }
                size_t CGpred_j_2_max__ = n_out;
                size_t CGpred_j_1_max__ = lentp;
                for (size_t j_2__ = 0; j_2__ < CGpred_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < CGpred_j_1_max__; ++j_1__) {
                        vars__.push_back(CGpred(j_1__, j_2__));
                    }
                }
                size_t Cmetpred_j_2_max__ = n_met;
                size_t Cmetpred_j_1_max__ = lentp;
                for (size_t j_2__ = 0; j_2__ < Cmetpred_j_2_max__; ++j_2__) {
                    for (size_t j_1__ = 0; j_1__ < Cmetpred_j_1_max__; ++j_1__) {
                        vars__.push_back(Cmetpred(j_1__, j_2__));
                    }
                }
                size_t y_sim_k_0_max__ = lentp;
                size_t y_sim_k_1_max__ = (1 + n_met);
                for (size_t k_1__ = 0; k_1__ < y_sim_k_1_max__; ++k_1__) {
                    for (size_t k_0__ = 0; k_0__ < y_sim_k_0_max__; ++k_0__) {
                        vars__.push_back(y_sim[k_0__][k_1__]);
                    }
                }
                size_t theta_k_0_max__ = (((n_exp + n_out) + n_met) + n_met);
                for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                    vars__.push_back(theta[k_0__]);
                }
            }
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_odeTK";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t log10ku_j_1_max__ = n_exp;
        for (size_t j_1__ = 0; j_1__ < log10ku_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10ku" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log10ke_j_1_max__ = n_out;
        for (size_t j_1__ = 0; j_1__ < log10ke_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10ke" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log10km_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10km_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10km" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log10kem_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10kem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10kem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigmaCGpred_k_0_max__ = n_out;
        for (size_t k_0__ = 0; k_0__ < sigmaCGpred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmaCGpred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigmaCmetpred_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < sigmaCmetpred_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmaCmetpred" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gmax_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < gmax_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gmax" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t G0_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < G0_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "G0" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ku_j_1_max__ = n_exp;
            for (size_t j_1__ = 0; j_1__ < ku_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ku" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ke_j_1_max__ = n_out;
            for (size_t j_1__ = 0; j_1__ < ke_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ke" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t km_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < km_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "km" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t kem_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < kem_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kem" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Cexp_j_2_max__ = n_exp;
            size_t Cexp_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < Cexp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cexp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Cexp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t CGpred_j_2_max__ = n_out;
            size_t CGpred_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < CGpred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < CGpred_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "CGpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Cmetpred_j_2_max__ = n_met;
            size_t Cmetpred_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < Cmetpred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cmetpred_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Cmetpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t y_sim_k_0_max__ = lentp;
            size_t y_sim_k_1_max__ = (1 + n_met);
            for (size_t k_1__ = 0; k_1__ < y_sim_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < y_sim_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_sim" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t theta_k_0_max__ = (((n_exp + n_out) + n_met) + n_met);
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t log10ku_j_1_max__ = n_exp;
        for (size_t j_1__ = 0; j_1__ < log10ku_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10ku" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log10ke_j_1_max__ = n_out;
        for (size_t j_1__ = 0; j_1__ < log10ke_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10ke" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log10km_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10km_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10km" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t log10kem_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < log10kem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "log10kem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigmaCGpred_k_0_max__ = n_out;
        for (size_t k_0__ = 0; k_0__ < sigmaCGpred_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmaCGpred" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t sigmaCmetpred_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < sigmaCmetpred_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "sigmaCmetpred" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t gmax_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < gmax_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "gmax" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t G0_k_0_max__ = (n_out - 1);
        for (size_t k_0__ = 0; k_0__ < G0_k_0_max__; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "G0" << '.' << k_0__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
            size_t ku_j_1_max__ = n_exp;
            for (size_t j_1__ = 0; j_1__ < ku_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ku" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t ke_j_1_max__ = n_out;
            for (size_t j_1__ = 0; j_1__ < ke_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "ke" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t km_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < km_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "km" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t kem_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < kem_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "kem" << '.' << j_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
            size_t Cexp_j_2_max__ = n_exp;
            size_t Cexp_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < Cexp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cexp_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Cexp" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t CGpred_j_2_max__ = n_out;
            size_t CGpred_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < CGpred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < CGpred_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "CGpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t Cmetpred_j_2_max__ = n_met;
            size_t Cmetpred_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < Cmetpred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cmetpred_j_1_max__; ++j_1__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "Cmetpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t y_sim_k_0_max__ = lentp;
            size_t y_sim_k_1_max__ = (1 + n_met);
            for (size_t k_1__ = 0; k_1__ < y_sim_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < y_sim_k_0_max__; ++k_0__) {
                    param_name_stream__.str(std::string());
                    param_name_stream__ << "y_sim" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                    param_names__.push_back(param_name_stream__.str());
                }
            }
            size_t theta_k_0_max__ = (((n_exp + n_out) + n_met) + n_met);
            for (size_t k_0__ = 0; k_0__ < theta_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_odeTK_namespace::model_odeTK stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
