% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_write.R
\name{bi_write}
\alias{bi_write}
\title{Create (init or observation) files for LibBi}
\usage{
bi_write(filename, variables, timed, ...)
}
\arguments{
\item{filename}{a path to a NetCDF file to write the variables into, which will be overwritten
if it already exists.}

\item{variables}{a \code{list} object, which names should be the variable names and values should be either single values, vectors of equal length, or data frames; or a single element of the type}

\item{timed}{if TRUE, any elements of \code{variables} that are vectors will be assumed to have a time dimension}

\item{...}{arguments passed to \code{\link{netcdf_create_from_list}}}
}
\value{
None, but creates a NetCDF file at the specified path.
}
\description{
This function creates an init file to specify
parameter values and initial conditions. This file
can then be passed to \code{libbi} using the \code{--init-file} option.
}
\examples{
filename <- tempfile(pattern="dummy", fileext=".nc")
a <- list(values = 1:3, dimension = "dim_a")
b <- list(values = 1:5, dimension = "dim_b")
c <- list(values = 5:9, dimension = "dim_b")
d <- 3
e <- data.frame(dim_a = rep(1:3, time = 2), dim_c = rep(1:2, each = 3), value = 1:6)
variables <- list(a=a, b=b, c=c, d=d, e=e)
bi_write(filename, variables)
bi_file_summary(filename)
bi_read(filename)
}

