% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_model.R
\name{bi_model_insert_lines}
\alias{bi_model_insert_lines}
\title{Insert lines in a libbi model}
\arguments{
\item{before}{line number before which to insert line(s)}

\item{after}{line number after which to insert line(s)}

\item{lines}{vector or line(s)}
}
\value{
the updated bi model
}
\description{
Inserts one or more lines into a libbi model. If one of \code{before} or \code{after} is given, the line(s) will be inserted before or after a given line number, respectively. If neither is given, the line(s) will be added at the end.
}
\examples{
model_file_name <- system.file(package="rbi", "PZ.bi")
PZ <- bi_model(filename = model_file_name)
PZ$insert_lines(lines = "noise beta", after = 8)
}
\seealso{
\code{\link{bi_model}}
}

