% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bi_model.R
\name{bi_model}
\alias{bi_model}
\title{Bi Model}
\usage{
bi_model(filename, lines, ...)
}
\arguments{
\item{filename}{the file name of the model file}

\item{lines}{lines of the model (if no \code{filename} is given), a character vector}

\item{...}{ignored}
}
\value{
a \code{{bi_model}} object containing the newly created model
}
\description{
\code{bi_model} creates a model object for \code{Rbi} from a libbi file, URL or character vector.
Once the instance is created, the model can be fed to a \code{\link{libbi}} object.
}
\examples{
model_file_name <- system.file(package="rbi", "PZ.bi")
PZ <- bi_model(filename = model_file_name)
}
\seealso{
\code{\link{fix}}, \code{\link{insert_lines}}, \code{\link{remove_lines}}, \code{\link{replace_all}}, \code{\link{get_name}}, \code{\link{set_name}}, \code{\link{write_model}}
}
