% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_getitemmetadata.R
\name{bhl_getitemmetadata}
\alias{bhl_getitemmetadata}
\title{Return metadata about an item.}
\usage{
bhl_getitemmetadata(itemid = NULL, pages = TRUE, ocr = FALSE,
  parts = FALSE, as = "table", key = NULL, ...)
}
\arguments{
\item{itemid}{item id (character)}

\item{pages}{return the items pages (\code{TRUE}/\code{FALSE})}

\item{ocr}{(logical) \code{TRUE} to return the ocr for the item's pages. Setting this
to \code{TRUE} apparently doesn't return any actual ocr text, but leaving parameter
here for now.}

\item{parts}{(logical) \code{TRUE} to return the item's parts. Setting this
to \code{TRUE} apparently doesn't return any parts text, but leaving parameter
here for now.}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
You may choose to include a list of the item's pages.
}
\examples{
\dontrun{
bhl_getitemmetadata('16800', TRUE)
bhl_getitemmetadata('16800', TRUE, as='xml')
bhl_getitemmetadata('16800', TRUE, as='json')
bhl_getitemmetadata('16800', TRUE, as='list')

# bhl_getitemmetadata(20419, pages=FALSE, parts=TRUE)
}
}

