% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate.R
\name{add.dates}
\alias{add.dates}
\title{Add dates to age-depth plots}
\usage{
add.dates(
  mn,
  sdev,
  depth,
  cc = 1,
  above = 1e-06,
  ex = 10,
  normal = TRUE,
  normalise = TRUE,
  t.a = 3,
  t.b = 4,
  age.res = 100,
  times = 20,
  col = rgb(1, 0, 0, 0.5),
  border = rgb(1, 0, 0, 0.5),
  rotate.axes = FALSE,
  mirror = TRUE,
  up = TRUE,
  BCAD = FALSE,
  pch = 4
)
}
\arguments{
\item{mn}{Reported mean of the date. Can be multiple dates.}

\item{sdev}{Reported error of the date. Can be multiple dates.}

\item{depth}{Depth of the date.}

\item{cc}{The calibration curve to use: \code{cc=1} for IntCal13 (northern hemisphere terrestrial), \code{cc=2} for Marine13 (marine), \code{cc=0} for none (dates that are already on the cal BP scale).}

\item{above}{Treshold for plotting of probability values. Defaults to \code{above=1e-3}.}

\item{ex}{Exaggeration of probability distribution plots. Defaults to \code{ex=50}.}

\item{normal}{By default, Bacon uses the student's t-distribution to treat the dates. Use \code{normal=TRUE} to use the normal/Gaussian distribution. This will generally give higher weight to the dates.}

\item{normalise}{By default, the date is normalised to an area of 1 (\code{normalise=TRUE}).}

\item{t.a}{The dates are treated using the student's t distribution by default (\code{normal=FALSE}).
The student's t-distribution has two parameters, t.a and t.b, set at 3 and 4 by default (see Christen and Perez, 2010).
If you want to assign narrower error distributions (more closely resembling the normal distribution), set t.a and t.b at for example 33 and 34 respectively (e.g., for specific dates in your .csv file).
For symmetry reasons, t.a must always be equal to t.b-1.}

\item{t.b}{The dates are treated using the student's t distribution by default (\code{normal=FALSE}).
The student's t-distribution has two parameters, t.a and t.b, set at 3 and 4 by default (see Christen and Perez, 2010).
If you want to assign narrower error distributions (more closely resembling the normal distribution), set t.a and t.b at for example 33 and 34 respectively (e.g., for specific dates in your .csv file).
For symmetry reasons, t.a must always be equal to t.b-1.}

\item{age.res}{Resolution of the date's distribution. Defaults to \code{date.res=100}.}

\item{times}{The extent of the range to be calculated for each date. Defaults to \code{times=20}.}

\item{col}{The colour of the ranges of the date. Default is semi-transparent red: \code{col=rgb(1,0,0,.5)}.}

\item{border}{The colours of the borders of the date. Default is semi-transparent red: \code{border=rgb(1,0,0,0.5)}.}

\item{rotate.axes}{The default of plotting age on the horizontal axis and event probability on the vertical one can be changed with \code{rotate.axes=TRUE}.}

\item{mirror}{Plot the dates as 'blobs'. Set to \code{mirror=FALSE} to plot simple distributions.}

\item{up}{Directions of distributions if they are plotted non-mirrored. Default \code{up=TRUE}.}

\item{BCAD}{The calendar scale of graphs is in \code{cal BP} by default, but can be changed to BC/AD using \code{BCAD=TRUE}.}

\item{pch}{The shape of any marker to be added to the date. Defaults to a cross, \code{pch=4}. To leave empty, use \code{pch=NA}.}
}
\value{
A date's distribution, added to an age-depth plot.
}
\description{
Add dated depths to plots, e.g. to show dates that weren't used in the age-depth model
}
\details{
Sometimes it is useful to add additional dating information to age-depth plots, e.g., to show outliers or how dates calibrate with different estimated offsets.
}
\examples{
\donttest{
  Bacon(run=FALSE, coredir=tempfile())
  agedepth()
  add.dates(5000, 100, 60)
}
}
\references{
Blaauw, M. and Christen, J.A., Flexible paleoclimate age-depth models using an autoregressive
gamma process. Bayesian Anal. 6 (2011), no. 3, 457--474.
\url{https://projecteuclid.org/euclid.ba/1339616472}
}
\seealso{
\url{http://www.qub.ac.uk/chrono/blaauw/manualBacon_2.3.pdf}
}
\author{
Maarten Blaauw, J. Andres Christen
}
