% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convolve.R
\name{grow_volume}
\alias{grow_volume}
\title{Grow volume mask}
\usage{
grow_volume(volume, x, y = x, z = x, threshold = 0.5)
}
\arguments{
\item{volume}{volume mask array, must be 3-dimensional array}

\item{x, y, z}{size of grow along each direction}

\item{threshold}{threshold after convolution}
}
\description{
Grow volume mask
}
\examples{


oldpar <- par(mfrow = c(2,3), mar = c(0.1,0.1,3.1,0.1))

mask <- array(0, c(21,21,21))
mask[11,11,11] <- 1
image(mask[11,,], asp = 1,
      main = "Original mask", axes = FALSE)
image(grow_volume(mask, 2)[11,,], asp = 1,
      main = "Dilated (size=2) mask", axes = FALSE)
image(grow_volume(mask, 5)[11,,], asp = 1,
      main = "Dilated (size=5) mask", axes = FALSE)

mask[11, sample(11,2), sample(11,2)] <- 1
image(mask[11,,], asp = 1,
      main = "Original mask", axes = FALSE)
image(grow_volume(mask, 2)[11,,], asp = 1,
      main = "Dilated (size=2) mask", axes = FALSE)
image(grow_volume(mask, 5)[11,,], asp = 1,
      main = "Dilated (size=5) mask", axes = FALSE)

par(oldpar)


}
