% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainvis.R
\name{read-brainvision-eeg}
\alias{read-brainvision-eeg}
\alias{read_eeg_header}
\alias{read_eeg_data}
\title{Load from 'BrainVision' file}
\usage{
read_eeg_header(file)

read_eeg_data(header, path = NULL)
}
\arguments{
\item{file}{path to \code{'vhdr'} header file}

\item{header}{header object returned by \code{read_eeg_header}}

\item{path}{optional, path to data file if original data file is missing or
renamed; must be absolute path.}
}
\value{
\code{read_eeg_header} returns a list containing information below:
\item{raw}{raw header contents}
\item{common}{a list of descriptors of header}
\item{channels}{table of channels, including number,
reference, resolution and unit}
\item{sample_rate}{sampling frequency}
\item{root_path}{directory to where the data is stored}
\item{channel_counts}{total channel counts}
\item{markers}{\code{NULL} if marker file is missing, or list of marker
description and table containing 6 columns.}
\code{read_eeg_data} returns header, signal data and data description:
\item{data}{a matrix of signal values. Each row is a channel and each
column is a time point.}
}
\description{
Read in \code{'eeg'} or \code{'ieeg'} data from 'BrainVision'
files with \code{.eeg} or \code{.dat} extensions.
}
\details{
A 'BrainVision' dataset is usually stored separately in header
file (\code{.vhdr}), marker file (\code{.vmrk}, optional) and
data file (\code{.eeg} or \code{.dat}). These files must store under a
same folder to be read into R.

Header data contains channel information. Data "channel" contains
channel name, reference, resolution and physical unit. "resolution"
times digital data values is the physical value of the recorded data.
\code{read_eeg_data} makes this conversion internally .
"unit" is the physical unit of recordings. By default \code{'uV'} means
micro-volts.

Marker file that ends with \code{.vmrk} is optional. If the file is
indicated by header file and exists, then a marker table will be included
when reading headers. A marker table contains six columns: marker number,
type, description, start position (in data point), size (duration in
data points), and target channel (0 means applied for all channels).

Signal file name is usually contained within header file. Therefore it is
desired that the signal file name never changed once created. However,
in some cases when the signal files are renamed and cannot be indexed
by header files, please specify \code{path} to force load signals from
a different file.
}
\examples{

header_file <- 'sub-01_ses-01_task-visual_run-01_ieeg.vhdr'

if( file.exists(header_file) ){
  # load a subject header
  header <- read_eeg_header(header_file)

  # load entire signal
  data <- read_eeg_data(header)

  data$description
}

}
