% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{is_valid_ish}
\alias{is_valid_ish}
\title{Check if data is close to ``valid"}
\usage{
is_valid_ish(
  x,
  min_len = 1,
  max_len = Inf,
  mode = NA,
  na = TRUE,
  blank = FALSE,
  all = FALSE
)
}
\arguments{
\item{x}{data to check}

\item{min_len, max_len}{minimal and maximum length}

\item{mode}{which storage mode (see \code{\link{mode}})
should \code{x} be considered valid. Default is \code{NA}: disabled.}

\item{na}{whether \code{NA} values considered invalid?}

\item{blank}{whether blank string considered invalid?}

\item{all}{if \code{na} or \code{blank} is true, whether all element
of \code{x} being invalid will result in failure?}
}
\value{
logicals whether input \code{x} is valid
}
\description{
Check if data is close to ``valid"
}
\examples{

# length checks
is_valid_ish(NULL)                     # FALSE
is_valid_ish(integer(0))               # FALSE
is_valid_ish(integer(0), min_len = 0)  # TRUE
is_valid_ish(1:10, max_len = 9)        # FALSE

# mode check
is_valid_ish(1:10)                     # TRUE
is_valid_ish(1:10, mode = 'numeric')   # TRUE
is_valid_ish(1:10, mode = 'character') # FALSE

# NA or blank checks
is_valid_ish(NA)                     # FALSE
is_valid_ish(c(1,2,NA), all = FALSE) # FALSE
is_valid_ish(c(1,2,NA), all = TRUE)  # TRUE as not all elements are NA

is_valid_ish(c('1',''), all = FALSE)  # TRUE
is_valid_ish(1:3, all = FALSE)        # TRUE as 1:3 are not characters


}
