% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/steel.R
\name{steel}
\alias{steel}
\title{Steel-type multiple contrast tests}
\usage{
steel(formula, data, control = NULL, alternative = c("two.sided",
  "less", "greater"), info = TRUE, correlation = TRUE)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the response variable and the right hand side contains 
the factor variable of interest.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. The default option is \code{NULL}.}

\item{control}{Specification of the control group for making many-to-one-comparisons. If NULL, all-pairwise comparisons are performed.}

\item{alternative}{Specification of the direction of the alternative. Default is two-sided.}

\item{info}{Logical. If TRUE, additional output information and explanation is printed to the console.}

\item{correlation}{Logical. If TRUE, the correlation matrix is printed.}
}
\value{
A \code{steel} object containing the following components:
\item{Call}{Given response and factor names (formula)}           
\item{Descriptive}{Descriptive statistics of the data for all levels of the factor.
                   Displayed are the names of the factor levels and the number of individuals per 
                   level (size)}
\item{Analysis}{Data frame containing the test results (comparison, relative effect estimator, standard error, test statistic and p-value.)}
}
\description{
The function implements purely nonparametric Steel-type multiple contrast tests for either making
many-to-one (Dunnett-type) or all pairwise (Tukey-type) comparisons.
Null hypotheses are formulated in terms of the distribution functions.
}
\details{
The steel() function calculates the Steel-type tests as explained by Munzel, U., Hothorn, L. A. (2001). A unified approach to simultaneous rank test procedures
in the unbalanced one-way layout. Biometrical Journal: Journal of Mathematical Methods in Biosciences, 43(5), 553-569.
}
\examples{

data(Muco)
model.oneway <- steel(HalfTime ~ Disease, data = Muco,info=TRUE,correlation=TRUE)


}
\references{
Brunner, E., Bathke, A.C., Konietschke, F. Rank and Pseudo-Rank Procedures 
for Independent Observations in Factorial Designs. Springer International Publishing, 2018.

Munzel, U., Hothorn, L. A. (2001). A unified approach to simultaneous rank test procedures in the unbalanced one-way layout. Biometrical Journal: Journal of
Mathematical Methods in Biosciences, 43(5), 553-569.

Konietschke, F., Hothorn, L. A., Brunner, E. (2012). Rank-based multiple test procedures and simultaneous confidence intervals. Electronic Journal of Statistics,
6, 738-759.
}
