% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranktwosamples.R
\name{rank.two.samples}
\alias{rank.two.samples}
\title{A function for analyzing two-sample problems}
\usage{
rank.two.samples(formula, data, conf.level = 0.95,
  alternative = c("two.sided", "less", "greater"), rounds = 3,
  method = c("logit", "probit", "normal", "t.app", "permu"),
  plot.simci = FALSE, info = TRUE, wilcoxon = c("asymptotic", "exact"),
  shift.int = TRUE, nperm = 10000)
}
\arguments{
\item{formula}{A model \code{\link{formula}} object. The left hand side
contains the response variable and the right hand side contains the factor
variables of interest. An interaction term must be specified.}

\item{data}{A data.frame, list or environment containing the variables in 
\code{formula}. The default option is \code{NULL}.}

\item{conf.level}{A number specifying the confidence level; the default is 0.95.}

\item{alternative}{Which alternative is considered? One of "two.sided", "less", "greater".}

\item{rounds}{Value specifying the number of digits the results are rounded to.}

\item{method}{specifying the method used for calculation of the confidence intervals.
One of "logit", "probit", "normal", "t.app" and "permu".}

\item{plot.simci}{Logical, indicating whether or not confidence intervals
should be plotted}

\item{info}{Logical. info = FALSE suppresses the output of additional information
concerning e.g. the interpretation of the test results.}

\item{wilcoxon}{asymptotic or exact calculation of Wilcoxon test.}

\item{shift.int}{Logical, indicating whether or not shift effects should be considered.}

\item{nperm}{Number of permutations used, default is 10000.}
}
\description{
The \code{rank.two.sample()} function calculates the weighted or unweighted treatment effect in
a two-sample problem. In addition to \code{\link{rankFD}}, the user can specify the alternative
and choose from a variety of different possibilities to calculate confidence intervals, see the details
below. Furthermore, a Wilcoxon test is calculate with the possibility to consider shift effects.
}
\details{
The confidence intervals are given for the treatment effect \eqn{p = P(X_1 < Y_1) + \frac{1}{2}P(X_1 = Y_1)}
underlying the Wilcoxon-Mann-Whitney test including tied data. Different methods for calculation can be chosen, 
see Pauly et al.(2016) for the permutation approach, Brunner and Munzel (2000) for the t-approximation and
Kaufmann et al.(2005) for the transformations. For plotting, the parameter plot.simci must be set to \code{TRUE}.
}
\examples{
data(Muco)
Muco2 <- subset(Muco, Disease != "OAD")
twosample <- rank.two.samples(HalfTime ~ Disease, data = Muco2, 
   alternative = "greater", method = "probit", wilcoxon = "exact", plot.simci = FALSE)

}
\references{
Brunner, E. and Munzel, U. (2000). The nonparametric Behrens-Fisher problem: Asymptotic
theory and a small-sample approximation. Biometrical Journal 1, 17 - 21.

Kaufmann, J., Werner, C., and Brunner, E. (2005). Nonparametric methods for analysing the
accuracy of diagnostic tests with multiple readers. Statistical Methods in Medical Research 14, 129 - 146

Pauly, M., Asendorf, T., and Konietschke, F. (2016). Permutation tests and confidence intervals for 
the area under the ROC-curve. Biometrical Journal, to appear.
}
\seealso{
\code{\link{rankFD}}
}

