% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5_get.R
\name{rmap_to_sf}
\alias{rmap_to_sf}
\alias{rmap_to_sf,rmapConnection,missing,missing-method}
\alias{rmap_to_sf,rmapConnection,character,missing-method}
\alias{rmap_to_sf,rmapConnection,missing,character-method}
\title{Get \code{sf} data.frame-s.}
\usage{
rmap_to_sf(con, src, pattern)

\S4method{rmap_to_sf}{rmapConnection,missing,missing}(con)

\S4method{rmap_to_sf}{rmapConnection,character,missing}(con, src)

\S4method{rmap_to_sf}{rmapConnection,missing,character}(con, pattern)
}
\arguments{
\item{con}{a rangeMapper connection made with  \code{\link[=rmap_connect]{rmap_connect()}}.}

\item{src}{the name of the source table. If missing all \code{map}s are returned.}

\item{pattern}{a string that identifies several map names. It can be a regular expression.}
}
\value{
an \link[sf]{sf} data.frame.
}
\description{
Convert \code{rangeMapper} to \code{sf}.
}
\details{
\code{rmap_to_sf()} retrieves one of the project's system tables:
\code{wkt_canvas}, \code{wkt_ranges} or \code{bbox} or one or several \code{map}-s tables.
}
\examples{

con = rmap_connect()
rmap_add_ranges(con, x = wrens, ID = 'sci_name')
rmap_prepare(con, 'hex', cellsize = 500, chunksize = 1)
rmap_save_map(con) # default is a species_richness map.
rmap_save_subset(con, dst = 'ss1', species_richness = 'species_richness > 5')
rmap_save_map(con, subset = 'ss1', dst = 'species_richness_min5')
x = rmap_to_sf(con)
x = rmap_to_sf(con, 'species_richness_min5')

dbDisconnect(con)
}
