% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rtbdPar.R
\name{rtbdPar}
\alias{rtbdPar}
\title{Representing Randomized Truncated Binomial Design}
\usage{
rtbdPar(N, rb = N, groups = LETTERS[1:2], filledBlock = FALSE)
}
\arguments{
\item{N}{integer for the total sample size of the trial.}

\item{rb}{block lengths of the blocks that can be selected equiprobable at random.}

\item{groups}{character vector of labels for the different treatments.}

\item{filledBlock}{\code{logical} whether the last block should be filled or not.}
}
\value{
\code{S4} object of the class \code{rtbdPar}.
}
\description{
Represents the randomization procedure Randomized Truncated Binomial Design.
}
\details{
Fix the possible random block lengths \code{rb} and the sample size of the trial \code{N}.
 Afterwards, one block length is
randomly selected of the random block lengths. In this block a fair coin is tossed
for the patient assignments until half of the patients have been assigend to one of
the treatment arms. Afterwards, the block is filled with the
other treatment. This procedure is repeated
until \code{N} patients are assigned.
}
\references{
W. F. Rosenberger and J. M. Lachin (2002) \emph{Randomization in Clinical Trials}.
Wiley.
}
\seealso{
Other randomization procedures: \code{\link{bsdPar}};
  \code{\link{crPar}}; \code{\link{createParam}};
  \code{\link{ebcPar}}; \code{\link{hadaPar}};
  \code{\link{mpPar}}; \code{\link{pbrPar}};
  \code{\link{rarPar}}; \code{\link{rpbrPar}};
  \code{\link{tbdPar}}; \code{\link{udPar}}
}

