/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.utils;

import eu.amidst.core.datastream.DataStream;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.utils.DynamicBayesianNetworkGenerator;
import eu.amidst.dynamic.utils.DynamicBayesianNetworkSampler;

public final class DataSetGenerator {
    public static DataStream<DynamicDataInstance> generate(int seed, int nSamples, int nDiscreteAtts, int nContinuousAttributes) {
        DynamicBayesianNetworkGenerator.setSeed(seed);
        DynamicBayesianNetworkGenerator.setNumberOfContinuousVars(nContinuousAttributes);
        DynamicBayesianNetworkGenerator.setNumberOfDiscreteVars(nDiscreteAtts);
        DynamicBayesianNetworkGenerator.setNumberOfStates(2);
        int nTotal = nDiscreteAtts + nContinuousAttributes;
        int nLinksMin = nTotal - 1;
        int nLinksMax = nTotal * (nTotal - 1) / 2;
        DynamicBayesianNetworkGenerator.setNumberOfLinks((int)(0.8 * (double)nLinksMin + 0.2 * (double)nLinksMax));
        DynamicBayesianNetwork dbn = DynamicBayesianNetworkGenerator.generateDynamicBayesianNetwork();
        DynamicBayesianNetworkSampler sampler = new DynamicBayesianNetworkSampler(dbn);
        sampler.setSeed(seed);
        return sampler.sampleToDataBase(nSamples / 50, 50);
    }

    public static DataStream<DynamicDataInstance> generate(int seed, int nSamples, int[] nDiscreteStates, int nContinuousAttributes) {
        DynamicBayesianNetworkGenerator.setSeed(seed);
        DynamicBayesianNetworkGenerator.setNumberOfContinuousVars(nContinuousAttributes);
        DynamicBayesianNetworkGenerator.setNumberOfDiscreteVars(nDiscreteStates.length);
        DynamicBayesianNetworkGenerator.setNumberOfStates(0);
        int nTotal = nDiscreteStates.length + nContinuousAttributes;
        int nLinksMin = nTotal - 1;
        int nLinksMax = nTotal * (nTotal - 1) / 2;
        DynamicBayesianNetworkGenerator.setNumberOfLinks((int)(0.8 * (double)nLinksMin + 0.2 * (double)nLinksMax));
        DynamicBayesianNetwork dbn = DynamicBayesianNetworkGenerator.generateDynamicBayesianNetwork(nDiscreteStates);
        DynamicBayesianNetworkSampler sampler = new DynamicBayesianNetworkSampler(dbn);
        sampler.setSeed(seed);
        return sampler.sampleToDataBase(nSamples / 50, 50);
    }
}

