/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.datastream.filereaders;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.filereaders.DataRow;
import eu.amidst.core.datastream.filereaders.DataRowMissing;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.datastream.filereaders.DynamicDataInstanceImpl;
import java.util.Iterator;

public final class NextDynamicDataInstance {
    private DataRow present;
    private DataRow past;
    private int sequenceID;
    private int timeIDcounter;
    private boolean startOfSequence = false;
    private DynamicDataInstanceImpl dynDataInstStart;

    public NextDynamicDataInstance(DataRow past, DataRow present, int sequenceID, int timeIDcounter) {
        this.past = past;
        this.present = present;
        this.sequenceID = sequenceID;
        this.timeIDcounter = timeIDcounter;
    }

    public DynamicDataInstance nextDataInstance_NoTimeID_NoSeq(Iterator<DataRow> reader) {
        DynamicDataInstanceImpl dynDataInst = null;
        if (this.timeIDcounter == 0) {
            dynDataInst = new DynamicDataInstanceImpl(this.past, this.present, this.sequenceID, this.timeIDcounter++);
        } else {
            this.past = this.present;
            this.present = reader.next();
            dynDataInst = new DynamicDataInstanceImpl(this.past, this.present, this.sequenceID, this.timeIDcounter++);
        }
        return dynDataInst;
    }

    public DynamicDataInstance nextDataInstance_NoSeq(Iterator<DataRow> reader, Attribute attTimeID) {
        double presentTimeID = this.present.getValue(attTimeID);
        if ((double)this.timeIDcounter < this.present.getValue(attTimeID)) {
            ++this.timeIDcounter;
            DynamicDataInstanceImpl dynDataInst = new DynamicDataInstanceImpl(this.past, new DataRowMissing(), this.sequenceID, (int)presentTimeID);
            this.past = new DataRowMissing();
            return dynDataInst;
        }
        if ((double)this.timeIDcounter == this.present.getValue(attTimeID)) {
            ++this.timeIDcounter;
            DynamicDataInstanceImpl dynDataInst = new DynamicDataInstanceImpl(this.past, this.present, this.sequenceID, (int)presentTimeID);
            this.past = this.present;
            return dynDataInst;
        }
        this.present = reader.next();
        return this.nextDataInstance_NoSeq(reader, attTimeID);
    }

    public DynamicDataInstance nextDataInstance_NoTimeID(Iterator<DataRow> reader, Attribute attSequenceID) {
        DynamicDataInstanceImpl dynDataInst = null;
        if (this.timeIDcounter == 0) {
            dynDataInst = new DynamicDataInstanceImpl(this.past, this.present, (int)this.present.getValue(attSequenceID), this.timeIDcounter);
            ++this.timeIDcounter;
            return dynDataInst;
        }
        this.past = this.present;
        this.present = reader.next();
        double pastSequenceID = this.past.getValue(attSequenceID);
        double presentSequenceID = this.present.getValue(attSequenceID);
        if (Double.isNaN(pastSequenceID) || pastSequenceID == presentSequenceID) {
            dynDataInst = new DynamicDataInstanceImpl(this.past, this.present, (int)presentSequenceID, this.timeIDcounter);
            ++this.timeIDcounter;
            return dynDataInst;
        }
        this.past = new DataRowMissing();
        this.timeIDcounter = 0;
        dynDataInst = new DynamicDataInstanceImpl(this.past, this.present, (int)presentSequenceID, this.timeIDcounter);
        ++this.timeIDcounter;
        return dynDataInst;
    }

    public DynamicDataInstance nextDataInstance(Iterator<DataRow> reader, Attribute attSequenceID, Attribute attTimeID) {
        double pastSequenceID = this.past.getValue(attSequenceID);
        double presentTimeID = this.present.getValue(attTimeID);
        if ((double)this.timeIDcounter < this.present.getValue(attTimeID)) {
            ++this.timeIDcounter;
            DynamicDataInstanceImpl dynDataInst = new DynamicDataInstanceImpl(this.past, new DataRowMissing(), (int)pastSequenceID, (int)presentTimeID);
            this.past = new DataRowMissing();
            return dynDataInst;
        }
        if ((double)this.timeIDcounter == this.present.getValue(attTimeID)) {
            ++this.timeIDcounter;
            DynamicDataInstanceImpl dynDataInst = new DynamicDataInstanceImpl(this.past, this.present, (int)pastSequenceID, (int)presentTimeID);
            this.past = this.present;
            return dynDataInst;
        }
        if (this.startOfSequence) {
            this.startOfSequence = false;
            return this.dynDataInstStart;
        }
        this.present = reader.next();
        double presentSequenceID = this.present.getValue(attSequenceID);
        if (pastSequenceID == presentSequenceID) {
            return this.nextDataInstance(reader, attSequenceID, attTimeID);
        }
        this.past = new DataRowMissing();
        this.dynDataInstStart = new DynamicDataInstanceImpl(this.past, this.present, (int)presentSequenceID, (int)this.present.getValue(attTimeID));
        this.past = this.present;
        this.timeIDcounter = 1;
        this.startOfSequence = true;
        return null;
    }
}

