/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.DeltaDistribution;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.ArrayList;
import java.util.Random;

public class IndicatorDistribution
extends ConditionalDistribution {
    private ConditionalDistribution conditionalDistribution;
    private DeltaDistribution deltaDist;
    private Variable indicatorVar;

    public IndicatorDistribution(Variable indicatorVar1, ConditionalDistribution conditionalDistribution1) {
        this.var = conditionalDistribution1.getVariable();
        this.parents = new ArrayList();
        for (Variable var : conditionalDistribution1.getConditioningVariables()) {
            this.parents.add(var);
        }
        this.parents.add(indicatorVar1);
        this.conditionalDistribution = conditionalDistribution1;
        this.indicatorVar = indicatorVar1;
        this.deltaDist = new DeltaDistribution(this.getVariable(), 0.0);
    }

    public ConditionalDistribution getConditionalDistribution() {
        return this.conditionalDistribution;
    }

    public Variable getIndicatorVar() {
        return this.indicatorVar;
    }

    @Override
    public double[] getParameters() {
        return new double[this.getNumberOfParameters()];
    }

    @Override
    public int getNumberOfParameters() {
        return 0;
    }

    @Override
    public double getLogConditionalProbability(Assignment assignment) {
        if (assignment.getValue(this.indicatorVar) == 0.0) {
            return 0.0;
        }
        return this.conditionalDistribution.getLogConditionalProbability(assignment);
    }

    @Override
    public UnivariateDistribution getUnivariateDistribution(Assignment assignment) {
        if (assignment.getValue(this.indicatorVar) == 0.0) {
            return this.deltaDist;
        }
        return this.conditionalDistribution.getUnivariateDistribution(assignment);
    }

    @Override
    public String label() {
        return "IndicatorDistribution of " + this.getConditionalDistribution().label();
    }

    @Override
    public void randomInitialization(Random random) {
        this.conditionalDistribution.randomInitialization(random);
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        if (dist instanceof IndicatorDistribution) {
            return this.equalDist((IndicatorDistribution)dist, threshold);
        }
        return false;
    }

    @Override
    public String toString() {
        return null;
    }

    public boolean equalDist(IndicatorDistribution dist, double threshold) {
        return this.getConditionalDistribution().equalDist(dist.getConditionalDistribution(), threshold);
    }
}

