% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rags2ridgesFused.R
\name{isSymmetricPD}
\alias{isSymmetricPD}
\alias{isSymmetricPSD}
\title{Test for symmetric positive (semi-)definiteness}
\usage{
isSymmetricPD(M)

isSymmetricPSD(M, tol = 1e-04)
}
\arguments{
\item{M}{A square symmetric matrix.}

\item{tol}{A numeric giving the tolerance for determining positive
semi-definiteness.}
}
\value{
Returns a \code{logical} value. Returns \code{TRUE} if the \code{M}
  is symmetric positive (semi)definite and \code{FALSE} if not.  If \code{M}
  is not even symmetric, the function throws an error.
}
\description{
Function to test if a \code{matrix} is symmetric positive (semi)definite or
not.
}
\details{
Tests positive definiteness by Cholesky decomposition.  Tests positive
semi-definiteness by checking if all eigenvalues are larger than
\eqn{-\epsilon|\lambda_1|} where \eqn{\epsilon} is the tolerance and
\eqn{\lambda_1} is the largest eigenvalue.

While \code{isSymmetricPSD} returns \code{TRUE} if the matrix is
  symmetric positive definite and \code{FASLE} if not. In practice, it tests
  if all eigenvalues are larger than -tol*|l| where l is the largest
  eigenvalue. More
  \href{https://scicomp.stackexchange.com/questions/12979/testing-if-a-matrix-is-positive-semi-definite}{here.}
}
\examples{
A <- matrix(rnorm(25), 5, 5)
\dontrun{
isSymmetricPD(A)
}
B <- symm(A)
isSymmetricPD(B)

C <- crossprod(B)
isSymmetricPD(C)

isSymmetricPSD(C)

}
\seealso{
\code{\link{isSymmetric}}
}
\author{
Anders Ellern Bilgrau Carel F.W. Peeters <carel.peeters@wur.nl>,
  Wessel N. van Wieringen
}
