% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agg_dev.R
\name{agg_supertransparent}
\alias{agg_supertransparent}
\title{Draw to a PNG file, modifying transparency on the fly}
\usage{
agg_supertransparent(filename = "Rplot\%03d.png", width = 480,
  height = 480, units = "px", pointsize = 12, background = "white",
  res = 72, alpha_mod = 1)
}
\arguments{
\item{filename}{The name of the file. Follows the same semantics as the file 
naming in [grDevices::png()], meaning that you can provide a [sprintf()] 
compliant string format to name multiple plots (such as the default value)}

\item{width}{The dimensions of the device}

\item{height}{The dimensions of the device}

\item{units}{The unit `width` and `height` is measured in, in either pixels 
(`'px'`), inches (`'in'`), millimeters (`'mm'`), or centimeter (`'cm'`).}

\item{pointsize}{The default pointsize of the device in pt}

\item{background}{The background colour of the device}

\item{res}{The resolution of the device. This setting will govern how device
dimensions given in inches, centimeters, or millimeters will be converted
to pixels. Further, it will be used to scale text sizes and linewidths}

\item{alpha_mod}{A numeric between 0 and 1 that will be multiplied to the 
alpha channel of all transparent colours}
}
\description{
The graphic engine in R only supports 8bit colours. This is for the most part
fine, as 8bit gives all the fidelity needed for most graphing needs. However,
this may become a limitation if you need to plot thousands of very 
translucent shapes on top of each other. 8bit only afford a minimum of 1/255
alpha, which may end up accumulating to fully opaque at some point. This 
device allows you to create a 16bit device that modifies the alpha level of 
all incomming colours by a fixed multiplier, thus allowing for much more 
translucent colours. The device will only modify transparent colour, so if
you pass in an opaque colour it will be left unchanged.
}
\keyword{internal}
