% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcnp_est_nps.R
\name{mcnp_est_nps}
\alias{mcnp_est_nps}
\title{Copy and paste MCNP tally fluctuation charts}
\usage{
mcnp_est_nps(err_target)
}
\arguments{
\item{err_target}{The target Monte Carlo uncertainty}
}
\value{
estimate of number of particle histories needed
}
\description{
Provides quick estimate of number of particles histories,
(nps) to obtain target MCNP 'error'.
Paste may include up to three tallies side by side in the default MCNP
order. For example, the headers of a three tally report includes column
names: nps, mean, error, vov, slope, fom, mean, error, vov, slope, fom,
mean, error, vov, slope, fom.
The structure of the tfc has been the same for versions 4 through 6,
including MCNPX.
}
\examples{
# Since this function requires the user
# to copy and paste input, this example
# is set up to provide data for this purpose.
# To run the example, copy and paste the following
# into an input file and delete the hash tags to run.
# Enter '1' for number of tallies.
# mcnp_est_nps(0.01)
#      32768000   4.5039E+00 0.2263 0.0969  0.0 5.0E-02
#      65536000   3.9877E+00 0.1561 0.0553  0.0 5.1E-02
#      98304000   3.4661E+00 0.1329 0.0413  0.0 4.7E-02
#     131072000   3.5087E+00 0.1132 0.0305  0.0 5.0E-02
#     163840000   3.5568E+00 0.0995 0.0228  0.0 5.2E-02
#     196608000   3.8508E+00 0.0875 0.0164  0.0 5.5E-02
#     229376000   3.8564E+00 0.0810 0.0135  0.0 5.5E-02
#     262144000   3.9299E+00 0.0760 0.0118  0.0 5.5E-02
#     294912000   4.0549E+00 0.0716 0.0100  0.0 5.6E-02
#     327680000   4.0665E+00 0.0686 0.0090  0.0 5.4E-02
#     360448000   4.1841E+00 0.0641 0.0079  0.0 5.7E-02
}
\seealso{
Other mcnp tools: 
\code{\link{mcnp_cone_angle}()},
\code{\link{mcnp_matrix_rotations}()},
\code{\link{mcnp_plot_out_spec}()},
\code{\link{mcnp_scan2plot}()},
\code{\link{mcnp_scan2spec}()},
\code{\link{mcnp_scan_save}()},
\code{\link{mcnp_si_sp_RD}()},
\code{\link{mcnp_si_sp_hist_scan}()},
\code{\link{mcnp_si_sp_hist}()}
}
\concept{mcnp tools}
