% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.R
\name{import_post}
\alias{import_post}
\alias{update_post}
\title{Import a post into a blog}
\usage{
import_post(url, slug = "auto", date = Sys.Date(),
  date_prefix = TRUE, check_license = TRUE, overwrite = FALSE,
  view = interactive())

update_post(slug, view = interactive())
}
\arguments{
\item{url}{URL for post to import}

\item{slug}{Post slug (directory name). Automatically computed from title if not
provided.}

\item{date}{Post date (defaults to current date)}

\item{date_prefix}{Data prefix for post slug (preserves chronological order for posts
within the filesystem).}

\item{check_license}{Verify that the imported posted has a creative commons license}

\item{overwrite}{Overwrite existing post? (defaults to \code{FALSE}, use \code{\link[=update_post]{update_post()}}
to update an existing post in-place).}

\item{view}{View the post after importing it.}
}
\value{
Returns (invisibly) a logical indicating whether the operation completed
(it may not complete if, for example, the user chose not to import an article
that lacked a creative commons license).
}
\description{
Import a post from an external source (e.g. GitHub repo, RPubs article, etc.).
}
