% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_mesh.R
\name{export_mesh}
\alias{export_mesh}
\title{Export Mesh}
\usage{
export_mesh(
  cylinder,
  filename,
  radius = NULL,
  color = NULL,
  palette = NULL,
  facets = 6,
  normals = FALSE
)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{filename}{File name and path for exporting. The .ply extension is automatically added if not present.}

\item{radius}{Vector of cylinder radii. Defaults to modified cylinders from the cylinder data frame.}

\item{color}{Optional cylinder color parameter. Colors must be a single hex color, a vector of hex colors, or a quoted column name. It can also be set to "random" to generate a random solid color, or FALSE to disable color on export. Vectors must have the same length as the cylinder data frame.}

\item{palette}{Optional color palette for numerical data. Palettes include: viridis, inferno, plasma, magma, cividis, and rainbow.}

\item{facets}{The number of facets in the polygon cross section. Defaults to 6, but can be increased to improve visual smoothness at the cost of performance and memory.}

\item{normals}{Option to export normals. Defaults to FALSE, but can be set to TRUE.}
}
\value{
A mesh .ply file
}
\description{
Exports QSM cylinder mesh using the rgl library
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)

filename <- tempfile(pattern = "QSM_mesh")
export_mesh(cylinder, filename)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder2 <- read.csv(file)
cylinder2 <- update_cylinders(cylinder2)

filename2 <- tempfile(pattern = "QSM_mesh2")
export_mesh(cylinder2, filename2)

## All Parameters

filename3 <- tempfile(pattern = "QSM_mesh3")
export_mesh(
  cylinder = cylinder,
  filename = filename3,
  radius = "UnmodRadius",
  color = "growthLength",
  palette = "viridis"
)

}
