/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javasvn;

import java.io.File;
import org.tigris.subversion.javahl.ClientException;
import org.tigris.subversion.javahl.Notify2;
import org.tigris.subversion.javahl.PromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.AbstractJhlClientAdapter;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javasvn.JavaSvnPromptUserPassword;
import org.tmatesoft.svn.core.javahl.SVNClientImpl;

public class JavaSvnClientAdapter
extends AbstractJhlClientAdapter {
    private ISVNClientAdapter svnAdmin;

    public JavaSvnClientAdapter() {
        this.svnClient = SVNClientImpl.newInstance();
        this.notificationHandler = new JhlNotificationHandler();
        this.svnClient.notification2((Notify2)this.notificationHandler);
        this.svnClient.setPrompt((PromptUserPassword)new AbstractJhlClientAdapter.DefaultPromptUserPassword());
    }

    public void createRepository(File file, String string) throws SVNClientException {
        this.getSvnAdmin();
        if (this.svnAdmin == null) {
            throw new SVNClientException("Create repository method not implemented.");
        }
        this.svnAdmin.createRepository(file, string);
    }

    private void getSvnAdmin() {
        if (this.svnAdmin == null) {
            try {
                JhlClientAdapterFactory.setup();
            }
            catch (SVNClientException sVNClientException) {
                // empty catch block
            }
            this.svnAdmin = SVNClientAdapterFactory.createSVNClient("javahl");
            if (this.svnAdmin == null) {
                try {
                    CmdLineClientAdapterFactory.setup();
                }
                catch (SVNClientException sVNClientException) {
                    // empty catch block
                }
                this.svnAdmin = SVNClientAdapterFactory.createSVNClient("commandline");
            }
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword iSVNPromptUserPassword) {
        if (iSVNPromptUserPassword != null) {
            JavaSvnPromptUserPassword javaSvnPromptUserPassword = new JavaSvnPromptUserPassword(iSVNPromptUserPassword);
            this.setPromptUserPassword((PromptUserPassword)javaSvnPromptUserPassword);
            if (this.svnAdmin != null) {
                this.svnAdmin.addPasswordCallback(iSVNPromptUserPassword);
            }
        }
    }

    public boolean statusReturnsRemoteInfo() {
        return true;
    }

    public long[] commitAcrossWC(File[] fileArray, String string, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        try {
            if (string == null) {
                string = "";
            }
            this.notificationHandler.setCommand(3);
            String[] stringArray = new String[fileArray.length];
            String string2 = "commit -m \"" + string + "\"";
            if (!bl) {
                string2 = string2 + " -N";
            }
            if (bl2) {
                string2 = string2 + " --no-unlock";
            }
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = JavaSvnClientAdapter.fileToSVNPath(fileArray[i], false);
                string2 = string2 + " " + stringArray[i];
            }
            this.notificationHandler.logCommandLine(string2);
            this.notificationHandler.setBaseDir();
            long[] lArray = ((SVNClientImpl)this.svnClient).commit(stringArray, string, bl, bl2, bl3);
            return lArray;
        }
        catch (ClientException clientException) {
            this.notificationHandler.logException((Exception)((Object)clientException));
            throw new SVNClientException(clientException);
        }
    }

    public boolean canCommitAcrossWC() {
        return true;
    }

    public ISVNStatus[] getStatus(File file, boolean bl, boolean bl2, boolean bl3) throws SVNClientException {
        ISVNStatus[] iSVNStatusArray = super.getStatus(file, bl, bl2, bl3);
        if (iSVNStatusArray.length == 0) {
            if (bl2) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            ISVNStatus[] iSVNStatusArray2 = super.getStatus(file, false, true, false);
            if (iSVNStatusArray2.length == 0) {
                return new ISVNStatus[]{new SVNStatusUnversioned(file)};
            }
            return new ISVNStatus[0];
        }
        return iSVNStatusArray;
    }
}

