/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.commandline;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.commandline.CmdLineXmlCommand;
import org.tigris.subversion.svnclientadapter.commandline.Helper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

class CmdLineLogMessage
extends CmdLineXmlCommand
implements ISVNLogMessage {
    private SVNRevision.Number rev;
    private String author;
    private Date date;
    private String msg;
    private ISVNLogMessageChangePath[] logMessageChangePaths;

    CmdLineLogMessage(SVNRevision.Number number, String string, Date date, String string2, ISVNLogMessageChangePath[] iSVNLogMessageChangePathArray) {
        this.rev = number;
        this.author = string;
        this.date = date;
        this.msg = string2;
        this.logMessageChangePaths = iSVNLogMessageChangePathArray;
    }

    CmdLineLogMessage(StringTokenizer stringTokenizer) {
        String string = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string, "|");
        String string2 = stringTokenizer2.nextToken();
        String string3 = stringTokenizer2.nextToken();
        String string4 = stringTokenizer2.nextToken();
        StringTokenizer stringTokenizer3 = new StringTokenizer(string2, ":");
        String string5 = stringTokenizer3.nextToken().trim();
        this.rev = Helper.toRevNum(string5.substring(4, string5.length()));
        this.author = stringTokenizer3.hasMoreTokens() ? stringTokenizer3.nextToken() : "";
        this.date = Helper.toDate(string3.trim());
        StringTokenizer stringTokenizer4 = new StringTokenizer(string4, " ");
        int n = Integer.parseInt(stringTokenizer4.nextToken());
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (i >= n - 1) continue;
            stringBuffer.append('\n');
        }
        this.msg = stringBuffer.toString();
        stringTokenizer.nextToken();
    }

    public SVNRevision.Number getRevision() {
        return this.rev;
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public String getMessage() {
        return this.msg;
    }

    public String toString() {
        return this.getMessage();
    }

    public static CmdLineLogMessage[] createLogMessages(byte[] byArray) throws SVNClientException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            InputSource inputSource = new InputSource(new ByteArrayInputStream(byArray));
            Document document = documentBuilderFactory.newDocumentBuilder().parse(inputSource);
            NodeList nodeList = document.getElementsByTagName("logentry");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Object object;
                ISVNLogMessageChangePath[] iSVNLogMessageChangePathArray;
                Node node = nodeList.item(i);
                Element element = CmdLineLogMessage.getFirstNamedElement(node, "author");
                if (element == null) {
                    throw new Exception("'author' tag expected under 'logentry'");
                }
                Element element2 = CmdLineLogMessage.getNextNamedElement(element, "date");
                if (element2 == null) {
                    throw new Exception("'date' tag expected under 'logentry'");
                }
                Element element3 = CmdLineLogMessage.getNextNamedElement(element2, "paths");
                Element element4 = CmdLineLogMessage.getNextNamedElement(element3 != null ? element3 : element2, "msg");
                Node node2 = node.getAttributes().getNamedItem("revision");
                SVNRevision.Number number = Helper.toRevNum(node2.getNodeValue());
                String string = element.getFirstChild().getNodeValue();
                Date date = Helper.convertXMLDate(element2.getFirstChild().getNodeValue());
                Node node3 = element4.getFirstChild();
                String string2 = node3 != null ? node3.getNodeValue() : "";
                ArrayList<SVNLogMessageChangePath> arrayList2 = new ArrayList<SVNLogMessageChangePath>();
                Element element5 = CmdLineLogMessage.getFirstNamedElement(element3, "path");
                while (element5 != null) {
                    iSVNLogMessageChangePathArray = element5.getFirstChild().getNodeValue();
                    object = element5.getAttributes();
                    char c = object.getNamedItem("action").getNodeValue().charAt(0);
                    Node node4 = object.getNamedItem("copyfrom-path");
                    Node node5 = object.getNamedItem("copyfrom-rev");
                    String string3 = null;
                    if (node4 != null) {
                        string3 = node4.getNodeValue();
                    }
                    SVNRevision.Number number2 = null;
                    if (node5 != null) {
                        number2 = Helper.toRevNum(node5.getNodeValue());
                    }
                    arrayList2.add(new SVNLogMessageChangePath((String)iSVNLogMessageChangePathArray, number2, string3, c));
                    element5 = CmdLineLogMessage.getNextNamedElement(element5, "path");
                }
                iSVNLogMessageChangePathArray = arrayList2.toArray(new ISVNLogMessageChangePath[arrayList2.size()]);
                object = new CmdLineLogMessage(number, string, date, string2, iSVNLogMessageChangePathArray);
                arrayList.add(object);
            }
        }
        catch (Exception exception) {
            throw new SVNClientException(exception);
        }
        return arrayList.toArray(new CmdLineLogMessage[arrayList.size()]);
    }

    public ISVNLogMessageChangePath[] getChangedPaths() {
        return this.logMessageChangePaths;
    }
}

