/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter;

import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;

public class SVNStatusUtils {
    public static boolean isManaged(SVNStatusKind sVNStatusKind) {
        return !sVNStatusKind.equals(SVNStatusKind.UNVERSIONED) && !sVNStatusKind.equals(SVNStatusKind.NONE) && !sVNStatusKind.equals(SVNStatusKind.IGNORED);
    }

    public static boolean isManaged(ISVNStatus iSVNStatus) {
        return SVNStatusUtils.isManaged(iSVNStatus.getTextStatus());
    }

    public static boolean hasRemote(SVNStatusKind sVNStatusKind) {
        return SVNStatusUtils.isManaged(sVNStatusKind) && !sVNStatusKind.equals(SVNStatusKind.ADDED);
    }

    public static boolean hasRemote(ISVNStatus iSVNStatus) {
        return SVNStatusUtils.hasRemote(iSVNStatus.getTextStatus());
    }

    public static boolean isAdded(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.ADDED);
    }

    public static boolean isDeleted(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.DELETED);
    }

    public static boolean isReplaced(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.REPLACED);
    }

    public static boolean isMissing(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.MISSING);
    }

    public static boolean isIgnored(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.IGNORED);
    }

    public static boolean isTextMerged(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.MERGED);
    }

    public static boolean isTextModified(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.MODIFIED);
    }

    public static boolean isTextConflicted(ISVNStatus iSVNStatus) {
        return iSVNStatus.getTextStatus().equals(SVNStatusKind.CONFLICTED);
    }

    public static boolean isPropModified(ISVNStatus iSVNStatus) {
        return iSVNStatus.getPropStatus().equals(SVNStatusKind.MODIFIED);
    }

    public static boolean isPropConflicted(ISVNStatus iSVNStatus) {
        return iSVNStatus.getPropStatus().equals(SVNStatusKind.CONFLICTED);
    }

    public static boolean isReadyForCommit(ISVNStatus iSVNStatus) {
        return SVNStatusUtils.isTextModified(iSVNStatus) || SVNStatusUtils.isAdded(iSVNStatus) || SVNStatusUtils.isDeleted(iSVNStatus) || SVNStatusUtils.isReplaced(iSVNStatus) || SVNStatusUtils.isPropModified(iSVNStatus) || SVNStatusUtils.isTextConflicted(iSVNStatus) || SVNStatusUtils.isPropConflicted(iSVNStatus) || !SVNStatusUtils.isManaged(iSVNStatus) && !SVNStatusUtils.isIgnored(iSVNStatus);
    }

    public static boolean isReadyForRevert(ISVNStatus iSVNStatus) {
        return SVNStatusUtils.isTextModified(iSVNStatus) || SVNStatusUtils.isAdded(iSVNStatus) || SVNStatusUtils.isDeleted(iSVNStatus) || SVNStatusUtils.isMissing(iSVNStatus) || SVNStatusUtils.isReplaced(iSVNStatus) || SVNStatusUtils.isPropModified(iSVNStatus) || SVNStatusUtils.isTextConflicted(iSVNStatus) || SVNStatusUtils.isPropConflicted(iSVNStatus);
    }
}

