/*
 * Decompiled with CFR 0.152.
 */
package org.python.expose.generate;

import java.util.List;
import org.python.expose.MethodType;
import org.python.expose.generate.ClassMethodExposer;
import org.python.expose.generate.DescriptorVisitor;
import org.python.expose.generate.Exposer;
import org.python.expose.generate.InstanceMethodExposer;
import org.python.expose.generate.NewExposer;
import org.python.expose.generate.OverridableNewExposer;
import org.python.expose.generate.PyTypes;
import org.python.expose.generate.RestrictiveAnnotationVisitor;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.MethodAdapter;
import org.python.objectweb.asm.MethodVisitor;
import org.python.objectweb.asm.Opcodes;
import org.python.objectweb.asm.Type;
import org.python.util.Generic;

public abstract class ExposedMethodFinder
extends MethodAdapter
implements PyTypes,
Opcodes {
    private Exposer newExp;
    private ExposedMethodVisitor methVisitor;
    private ExposedMethodVisitor classMethVisitor;
    private Type onType;
    private String methodDesc;
    private String typeName;
    private String methodName;
    private String[] exceptions;
    private int access;

    public ExposedMethodFinder(String typeName, Type onType, int access, String name, String desc, String[] exceptions2, MethodVisitor delegate) {
        super(delegate);
        this.typeName = typeName;
        this.onType = onType;
        this.access = access;
        this.methodName = name;
        this.methodDesc = desc;
        this.exceptions = exceptions2;
    }

    public abstract void handleResult(InstanceMethodExposer var1);

    public abstract void handleResult(ClassMethodExposer var1);

    public abstract void handleNewExposer(Exposer var1);

    public abstract void exposeAsGetDescriptor(String var1);

    public abstract void exposeAsSetDescriptor(String var1);

    public abstract void exposeAsDeleteDescriptor(String var1);

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (desc.equals(EXPOSED_NEW.getDescriptor())) {
            this.newExp = (this.access & 8) != 0 ? new NewExposer(this.onType, this.access, this.methodName, this.methodDesc, this.exceptions) : new OverridableNewExposer(this.onType, Type.getType("L" + this.onType.getInternalName() + "Derived;"), this.access, this.methodName, this.methodDesc, this.exceptions);
        } else {
            if (desc.equals(EXPOSED_METHOD.getDescriptor())) {
                this.methVisitor = new ExposedMethodVisitor();
                return this.methVisitor;
            }
            if (desc.equals(EXPOSED_CLASS_METHOD.getDescriptor())) {
                this.classMethVisitor = new ExposedMethodVisitor();
                return this.classMethVisitor;
            }
            if (desc.equals(EXPOSED_GET.getDescriptor())) {
                return new DescriptorVisitor(this.methodName){

                    public void handleResult(String name) {
                        ExposedMethodFinder.this.exposeAsGetDescriptor(name);
                    }
                };
            }
            if (desc.equals(EXPOSED_SET.getDescriptor())) {
                return new DescriptorVisitor(this.methodName){

                    public void handleResult(String name) {
                        ExposedMethodFinder.this.exposeAsSetDescriptor(name);
                    }
                };
            }
            if (desc.equals(EXPOSED_DELETE.getDescriptor())) {
                return new DescriptorVisitor(this.methodName){

                    public void handleResult(String name) {
                        ExposedMethodFinder.this.exposeAsDeleteDescriptor(name);
                    }
                };
            }
        }
        return super.visitAnnotation(desc, visible);
    }

    public void visitEnd() {
        if (this.methVisitor != null) {
            this.handleResult(new InstanceMethodExposer(this.onType, this.access, this.methodName, this.methodDesc, this.typeName, this.methVisitor.names, this.methVisitor.defaults, this.methVisitor.type, this.methVisitor.doc));
        }
        if (this.newExp != null) {
            this.handleNewExposer(this.newExp);
        }
        if (this.classMethVisitor != null) {
            this.handleResult(new ClassMethodExposer(this.onType, this.access, this.methodName, this.methodDesc, this.typeName, this.classMethVisitor.names, this.classMethVisitor.defaults, this.classMethVisitor.doc));
        }
        super.visitEnd();
    }

    class ExposedMethodVisitor
    extends RestrictiveAnnotationVisitor {
        private String[] names = new String[0];
        private String[] defaults = new String[0];
        private MethodType type = MethodType.DEFAULT;
        private String doc = "";

        ExposedMethodVisitor() {
        }

        public void visit(String name, Object value) {
            if (name.equals("doc")) {
                this.doc = (String)value;
            } else {
                super.visit(name, value);
            }
        }

        public AnnotationVisitor visitArray(String name) {
            if (name.equals("names")) {
                return new StringArrayBuilder(){

                    public void handleResult(String[] result) {
                        ExposedMethodVisitor.access$102(ExposedMethodVisitor.this, result);
                    }
                };
            }
            if (name.equals("defaults")) {
                return new StringArrayBuilder(){

                    public void handleResult(String[] result) {
                        ExposedMethodVisitor.access$202(ExposedMethodVisitor.this, result);
                    }
                };
            }
            return super.visitArray(name);
        }

        public void visitEnum(String name, String desc, String value) {
            if (name.equals("type")) {
                this.type = MethodType.valueOf(value);
            } else {
                super.visitEnum(name, desc, value);
            }
        }

        static /* synthetic */ String[] access$102(ExposedMethodVisitor x0, String[] x1) {
            x0.names = x1;
            return x1;
        }

        static /* synthetic */ String[] access$202(ExposedMethodVisitor x0, String[] x1) {
            x0.defaults = x1;
            return x1;
        }
    }

    private abstract class StringArrayBuilder
    extends RestrictiveAnnotationVisitor {
        List<String> vals = Generic.list();

        private StringArrayBuilder() {
        }

        public void visit(String name, Object value) {
            this.vals.add((String)value);
        }

        public void visitEnd() {
            this.handleResult(this.vals.toArray(new String[this.vals.size()]));
        }

        public abstract void handleResult(String[] var1);
    }
}

