/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyException;
import org.python.core.PyIgnoreMethodTag;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequenceIter;
import org.python.core.PySlice;
import org.python.core.PyTuple;
import org.python.core.PyType;

public abstract class PySequence
extends PyObject {
    public int gListAllocatedStatus = -1;

    public PySequence() {
    }

    protected PySequence(PyType type) {
        super(type);
    }

    protected abstract PyObject pyget(int var1);

    protected abstract PyObject getslice(int var1, int var2, int var3);

    protected abstract PyObject repeat(int var1);

    protected void set(int index, PyObject value) {
        throw Py.TypeError("can't assign to immutable object");
    }

    protected void setslice(int start, int stop, int step, PyObject value) {
        throw Py.TypeError(String.format("'%s' object does not support item assignment", this.getType().fastGetName()));
    }

    protected void del(int i) throws PyException {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    protected void delRange(int start, int stop, int step) {
        throw Py.TypeError(String.format("'%s' object does not support item deletion", this.getType().fastGetName()));
    }

    public boolean __nonzero__() {
        return this.seq___nonzero__();
    }

    final boolean seq___nonzero__() {
        return this.__len__() != 0;
    }

    public PyObject __iter__() {
        return this.seq___iter__();
    }

    final PyObject seq___iter__() {
        return new PySequenceIter(this);
    }

    public synchronized PyObject __eq__(PyObject o) {
        return this.seq___eq__(o);
    }

    final synchronized PyObject seq___eq__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.False;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.True : Py.False;
    }

    public synchronized PyObject __ne__(PyObject o) {
        return this.seq___ne__(o);
    }

    final synchronized PyObject seq___ne__(PyObject o) {
        int ol;
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o.__len__())) {
            return Py.True;
        }
        int i = PySequence.cmp(this, tl, o, ol);
        return i < 0 ? Py.False : Py.True;
    }

    public synchronized PyObject __lt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._lt(o.__finditem__(i));
    }

    final synchronized PyObject seq___lt__(PyObject o) {
        return this.__lt__(o);
    }

    public synchronized PyObject __le__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -1 || i == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._le(o.__finditem__(i));
    }

    final synchronized PyObject seq___le__(PyObject o) {
        return this.__le__(o);
    }

    public synchronized PyObject __gt__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._gt(o.__finditem__(i));
    }

    final synchronized PyObject seq___gt__(PyObject o) {
        return this.__gt__(o);
    }

    public synchronized PyObject __ge__(PyObject o) {
        if (this.getType() != o.getType() && !this.getType().isSubType(o.getType())) {
            return null;
        }
        int i = PySequence.cmp(this, -1, o, -1);
        if (i < 0) {
            return i == -3 || i == -2 ? Py.True : Py.False;
        }
        return this.__finditem__(i)._ge(o.__finditem__(i));
    }

    final synchronized PyObject seq___ge__(PyObject o) {
        return this.__ge__(o);
    }

    protected static int cmp(PyObject o1, int ol1, PyObject o2, int ol2) {
        if (ol1 < 0) {
            ol1 = o1.__len__();
        }
        if (ol2 < 0) {
            ol2 = o2.__len__();
        }
        for (int i = 0; i < ol1 && i < ol2; ++i) {
            if (o1.__getitem__(i)._eq(o2.__getitem__(i)).__nonzero__()) continue;
            return i;
        }
        if (ol1 == ol2) {
            return -2;
        }
        return ol1 < ol2 ? -1 : -3;
    }

    protected static PyObject fastSequence(PyObject seq, String msg) {
        if (seq instanceof PyList || seq instanceof PyTuple) {
            return seq;
        }
        PyList list = new PyList();
        PyObject iter = Py.iter(seq, msg);
        PyObject item = null;
        while ((item = iter.__iternext__()) != null) {
            list.append(item);
        }
        return list;
    }

    protected static final int sliceLength(int start, int stop, long step) {
        int ret = step > 0L ? (int)(((long)(stop - start) + step - 1L) / step) : (int)(((long)(stop - start) + step + 1L) / step);
        if (ret < 0) {
            return 0;
        }
        return ret;
    }

    protected int fixindex(int index) {
        int l = this.__len__();
        if (index < 0) {
            index += l;
        }
        if (index < 0 || index >= l) {
            return -1;
        }
        return index;
    }

    protected int calculateIndex(int index) {
        int length = this.__len__();
        if (index < 0) {
            index += length;
            if (index < 0) {
                index = 0;
            }
        } else if (index > length) {
            index = length;
        }
        return index;
    }

    public PyObject __finditem__(int index) {
        return this.seq___finditem__(index);
    }

    final synchronized PyObject seq___finditem__(int index) {
        if ((index = this.fixindex(index)) == -1) {
            return null;
        }
        return this.pyget(index);
    }

    public PyObject __finditem__(PyObject index) {
        return this.seq___finditem__(index);
    }

    final PyObject seq___finditem__(PyObject index) {
        if (index.isIndex()) {
            return this.seq___finditem__(index.asIndex(Py.IndexError));
        }
        if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            return this.seq___getslice__(s.start, s.stop, s.step);
        }
        throw Py.TypeError(this.getType().fastGetName() + " indices must be integers");
    }

    public PyObject __getitem__(PyObject index) {
        return this.seq___getitem__(index);
    }

    final PyObject seq___getitem__(PyObject index) {
        PyObject ret = this.__finditem__(index);
        if (ret == null) {
            throw Py.IndexError("index out of range: " + index);
        }
        return ret;
    }

    public boolean isMappingType() throws PyIgnoreMethodTag {
        return false;
    }

    public boolean isNumberType() throws PyIgnoreMethodTag {
        return false;
    }

    public synchronized PyObject __getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    final synchronized PyObject seq___getslice__(PyObject start, PyObject stop) {
        return this.seq___getslice__(start, stop, null);
    }

    final synchronized PyObject seq___getslice__(PyObject start, PyObject stop, PyObject step) {
        int[] indices = new PySlice(start, stop, step).indicesEx(this.__len__());
        return this.getslice(indices[0], indices[1], indices[2]);
    }

    public synchronized void __setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        this.seq___setslice__(start, stop, step, value);
    }

    final synchronized void seq___setslice__(PyObject start, PyObject stop, PyObject value) {
        this.seq___setslice__(start, stop, null, value);
    }

    final synchronized void seq___setslice__(PyObject start, PyObject stop, PyObject step, PyObject value) {
        PySlice slice = new PySlice(start, stop, step);
        int[] indices = slice.indicesEx(this.__len__());
        if (slice.step != Py.None && value.__len__() != indices[3]) {
            throw Py.ValueError(String.format("attempt to assign sequence of size %d to extended slice of size %d", value.__len__(), indices[3]));
        }
        this.setslice(indices[0], indices[1], indices[2], value);
    }

    public synchronized void __delslice__(PyObject start, PyObject stop, PyObject step) {
        this.seq___delslice__(start, stop, step);
    }

    final synchronized void seq___delslice__(PyObject start, PyObject stop, PyObject step) {
        int[] indices = new PySlice(start, stop, step).indicesEx(this.__len__());
        this.delRange(indices[0], indices[1], indices[2]);
    }

    public synchronized void __setitem__(int index, PyObject value) {
        this.seq___setitem__(index, value);
    }

    final synchronized void seq___setitem__(int index, PyObject value) {
        int i = this.fixindex(index);
        if (i == -1) {
            throw Py.IndexError(this.getType().fastGetName() + " assignment index out of range");
        }
        this.set(i, value);
    }

    public void __setitem__(PyObject index, PyObject value) {
        this.seq___setitem__(index, value);
    }

    final void seq___setitem__(PyObject index, PyObject value) {
        if (index.isIndex()) {
            this.seq___setitem__(index.asIndex(Py.IndexError), value);
        } else if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            this.seq___setslice__(s.start, s.stop, s.step, value);
        } else {
            throw Py.TypeError(this.getType().fastGetName() + " indices must be integers");
        }
    }

    public synchronized void __delitem__(PyObject index) {
        this.seq___delitem__(index);
    }

    final synchronized void seq___delitem__(PyObject index) {
        if (index.isIndex()) {
            int i = this.fixindex(index.asIndex(Py.IndexError));
            if (i == -1) {
                throw Py.IndexError(this.getType().fastGetName() + " assignment index out of range");
            }
            this.del(i);
        } else if (index instanceof PySlice) {
            PySlice s = (PySlice)index;
            this.seq___delslice__(s.start, s.stop, s.step);
        } else {
            throw Py.TypeError(this.getType().fastGetName() + " indices must be integers");
        }
    }

    public synchronized Object __tojava__(Class c) throws PyIgnoreMethodTag {
        if (c.isArray()) {
            Class<?> component = c.getComponentType();
            try {
                int n = this.__len__();
                PyArray array = new PyArray(component, n);
                for (int i = 0; i < n; ++i) {
                    PyObject o = this.pyget(i);
                    array.set(i, o);
                }
                return array.getArray();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.__tojava__(c);
    }

    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{2}''";
        }
        return null;
    }

    protected String runsupportedopMessage(String op, PyObject o2) {
        if (op.equals("*")) {
            return "can''t multiply sequence by non-int of type ''{1}''";
        }
        return null;
    }
}

