/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigDecimal;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat$PyExposer;
import org.python.core.PyFloatDerived;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.expose.ExposedNew;

public class PyFloat
extends PyObject {
    private static final int PREC_REPR = 17;
    private static final int PREC_STR = 12;
    public static final PyType TYPE;
    private double value;
    public static volatile Format double_format;
    public static volatile Format float_format;

    @ExposedNew
    public static PyObject float_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("float", args, keywords, new String[]{"x"}, 0);
        PyObject x = ap.getPyObject(0, null);
        if (x == null) {
            if (new_.for_type == subtype) {
                return new PyFloat(0.0);
            }
            return new PyFloatDerived(subtype, 0.0);
        }
        PyFloat floatObject = null;
        try {
            floatObject = x.__float__();
        }
        catch (PyException e) {
            if (Py.matchException(e, Py.AttributeError)) {
                throw Py.TypeError("float() argument must be a string or a number");
            }
            throw e;
        }
        if (new_.for_type == subtype) {
            return floatObject;
        }
        return new PyFloatDerived(subtype, floatObject.getValue());
    }

    public PyFloat(PyType subtype, double v) {
        super(subtype);
        this.value = v;
    }

    public PyFloat(double v) {
        this(TYPE, v);
    }

    public PyFloat(float v) {
        this((double)v);
    }

    public boolean isFinite() {
        return !Double.isInfinite(this.value) && !Double.isNaN(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return this.__str__().toString();
    }

    public PyString __str__() {
        return this.float___str__();
    }

    final PyString float___str__() {
        return Py.newString(this.formatDouble(12));
    }

    public PyString __repr__() {
        return this.float___repr__();
    }

    final PyString float___repr__() {
        return Py.newString(this.formatDouble(17));
    }

    private String formatDouble(int precision) {
        if (Double.isNaN(this.value)) {
            return "nan";
        }
        String result = String.format("%%.%dg", precision);
        result = Py.newString(result).__mod__(this).toString();
        int i = 0;
        if (result.startsWith("-")) {
            ++i;
        }
        while (i < result.length() && Character.isDigit(result.charAt(i))) {
            ++i;
        }
        if (i == result.length()) {
            result = result + ".0";
        }
        return result;
    }

    public int hashCode() {
        return this.float___hash__();
    }

    final int float___hash__() {
        double intPart = Math.floor(this.value);
        double fractPart = this.value - intPart;
        if (fractPart == 0.0) {
            if (intPart <= 2.147483647E9 && intPart >= -2.147483648E9) {
                return (int)this.value;
            }
            return this.__long__().hashCode();
        }
        long v = Double.doubleToLongBits(this.value);
        return (int)v ^ (int)(v >> 32);
    }

    public boolean __nonzero__() {
        return this.float___nonzero__();
    }

    final boolean float___nonzero__() {
        return this.value != 0.0;
    }

    public Object __tojava__(Class c) {
        if (c == Double.TYPE || c == Number.class || c == Double.class || c == Object.class || c == Serializable.class) {
            return new Double(this.value);
        }
        if (c == Float.TYPE || c == Float.class) {
            return new Float(this.value);
        }
        return super.__tojava__(c);
    }

    public PyObject __eq__(PyObject other) {
        if (Double.isNaN(this.value)) {
            return Py.False;
        }
        return null;
    }

    public PyObject __ne__(PyObject other) {
        if (Double.isNaN(this.value)) {
            return Py.True;
        }
        return null;
    }

    public int __cmp__(PyObject other) {
        return this.float___cmp__(other);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final int float___cmp__(PyObject other) {
        double j;
        double i = this.value;
        if (other instanceof PyFloat) {
            j = ((PyFloat)other).value;
        } else if (!this.isFinite()) {
            if (!(other instanceof PyInteger)) {
                if (!(other instanceof PyLong)) return -2;
            }
            j = 0.0;
        } else if (other instanceof PyInteger) {
            j = ((PyInteger)other).getValue();
        } else {
            if (!(other instanceof PyLong)) return -2;
            BigDecimal v = new BigDecimal(this.value);
            BigDecimal w = new BigDecimal(((PyLong)other).getValue());
            return v.compareTo(w);
        }
        if (i < j) {
            return -1;
        }
        if (i > j) {
            return 1;
        }
        if (i == j) {
            return 0;
        }
        if (!Double.isNaN(i)) return 1;
        if (!Double.isNaN(j)) return -1;
        return 1;
    }

    public Object __coerce_ex__(PyObject other) {
        return this.float___coerce_ex__(other);
    }

    final PyObject float___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.float___coerce_ex__(other));
    }

    final Object float___coerce_ex__(PyObject other) {
        if (other instanceof PyFloat) {
            return other;
        }
        if (other instanceof PyInteger) {
            return new PyFloat((double)((PyInteger)other).getValue());
        }
        if (other instanceof PyLong) {
            return new PyFloat(((PyLong)other).doubleValue());
        }
        return Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyFloat || other instanceof PyInteger || other instanceof PyLong;
    }

    private static final double coerce(PyObject other) {
        if (other instanceof PyFloat) {
            return ((PyFloat)other).value;
        }
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        if (other instanceof PyLong) {
            return ((PyLong)other).doubleValue();
        }
        throw Py.TypeError("xxx");
    }

    public PyObject __add__(PyObject right) {
        return this.float___add__(right);
    }

    final PyObject float___add__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value + rightv);
    }

    public PyObject __radd__(PyObject left) {
        return this.float___radd__(left);
    }

    final PyObject float___radd__(PyObject left) {
        return this.__add__(left);
    }

    public PyObject __sub__(PyObject right) {
        return this.float___sub__(right);
    }

    final PyObject float___sub__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value - rightv);
    }

    public PyObject __rsub__(PyObject left) {
        return this.float___rsub__(left);
    }

    final PyObject float___rsub__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(leftv - this.value);
    }

    public PyObject __mul__(PyObject right) {
        return this.float___mul__(right);
    }

    final PyObject float___mul__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(this.value * rightv);
    }

    public PyObject __rmul__(PyObject left) {
        return this.float___rmul__(left);
    }

    final PyObject float___rmul__(PyObject left) {
        return this.__mul__(left);
    }

    public PyObject __div__(PyObject right) {
        return this.float___div__(right);
    }

    final PyObject float___div__(PyObject right) {
        double rightv;
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        if ((rightv = PyFloat.coerce(right)) == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / rightv);
    }

    public PyObject __rdiv__(PyObject left) {
        return this.float___rdiv__(left);
    }

    final PyObject float___rdiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        if (Options.divisionWarning >= 2) {
            Py.warning(Py.DeprecationWarning, "classic float division");
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.value);
    }

    public PyObject __floordiv__(PyObject right) {
        return this.float___floordiv__(right);
    }

    final PyObject float___floordiv__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(this.value / rightv));
    }

    public PyObject __rfloordiv__(PyObject left) {
        return this.float___rfloordiv__(left);
    }

    final PyObject float___rfloordiv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(Math.floor(leftv / this.value));
    }

    public PyObject __truediv__(PyObject right) {
        return this.float___truediv__(right);
    }

    final PyObject float___truediv__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(this.value / rightv);
    }

    public PyObject __rtruediv__(PyObject left) {
        return this.float___rtruediv__(left);
    }

    final PyObject float___rtruediv__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        return new PyFloat(leftv / this.value);
    }

    private static double modulo(double x, double y) {
        if (y == 0.0) {
            throw Py.ZeroDivisionError("float modulo");
        }
        double z = Math.IEEEremainder(x, y);
        if (z * y < 0.0) {
            z += y;
        }
        return z;
    }

    public PyObject __mod__(PyObject right) {
        return this.float___mod__(right);
    }

    final PyObject float___mod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        return new PyFloat(PyFloat.modulo(this.value, rightv));
    }

    public PyObject __rmod__(PyObject left) {
        return this.float___rmod__(left);
    }

    final PyObject float___rmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        return new PyFloat(PyFloat.modulo(leftv, this.value));
    }

    public PyObject __divmod__(PyObject right) {
        return this.float___divmod__(right);
    }

    final PyObject float___divmod__(PyObject right) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        double rightv = PyFloat.coerce(right);
        if (rightv == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(this.value / rightv);
        return new PyTuple(new PyFloat(z), new PyFloat(this.value - z * rightv));
    }

    public PyObject __rdivmod__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        double leftv = PyFloat.coerce(left);
        if (this.value == 0.0) {
            throw Py.ZeroDivisionError("float division");
        }
        double z = Math.floor(leftv / this.value);
        return new PyTuple(new PyFloat(z), new PyFloat(leftv - z * this.value));
    }

    final PyObject float___rdivmod__(PyObject left) {
        return this.__rdivmod__(left);
    }

    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.float___pow__(right, modulo);
    }

    final PyObject float___pow__(PyObject right, PyObject modulo) {
        if (!PyFloat.canCoerce(right)) {
            return null;
        }
        if (modulo != null) {
            throw Py.TypeError("pow() 3rd argument not allowed unless all arguments are integers");
        }
        return PyFloat._pow(this.value, PyFloat.coerce(right), modulo);
    }

    final PyObject float___rpow__(PyObject left) {
        return this.__rpow__(left);
    }

    public PyObject __rpow__(PyObject left) {
        if (!PyFloat.canCoerce(left)) {
            return null;
        }
        return PyFloat._pow(PyFloat.coerce(left), this.value, null);
    }

    private static PyFloat _pow(double value, double iw, PyObject modulo) {
        if (iw == 0.0) {
            if (modulo != null) {
                return new PyFloat(PyFloat.modulo(1.0, PyFloat.coerce(modulo)));
            }
            return new PyFloat(1.0);
        }
        if (value == 0.0) {
            if (iw < 0.0) {
                throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
            }
            return new PyFloat(0.0f);
        }
        if (value < 0.0 && iw != Math.floor(iw)) {
            throw Py.ValueError("negative number cannot be raised to a fractional power");
        }
        double ret = Math.pow(value, iw);
        if (modulo == null) {
            return new PyFloat(ret);
        }
        return new PyFloat(PyFloat.modulo(ret, PyFloat.coerce(modulo)));
    }

    public PyObject __neg__() {
        return this.float___neg__();
    }

    final PyObject float___neg__() {
        return new PyFloat(-this.value);
    }

    public PyObject __pos__() {
        return this.float___pos__();
    }

    final PyObject float___pos__() {
        return Py.newFloat(this.value);
    }

    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    public PyObject __abs__() {
        return this.float___abs__();
    }

    final PyObject float___abs__() {
        if (this.value >= 0.0) {
            return Py.newFloat(this.value);
        }
        return this.__neg__();
    }

    public PyObject __int__() {
        return this.float___int__();
    }

    final PyObject float___int__() {
        if (this.value <= 2.147483647E9 && this.value >= -2.147483648E9) {
            return new PyInteger((int)this.value);
        }
        return this.__long__();
    }

    public PyObject __long__() {
        return this.float___long__();
    }

    final PyObject float___long__() {
        return new PyLong(this.value);
    }

    public PyFloat __float__() {
        return this.float___float__();
    }

    final PyFloat float___float__() {
        return Py.newFloat(this.value);
    }

    public PyComplex __complex__() {
        return new PyComplex(this.value, 0.0);
    }

    final PyTuple float___getnewargs__() {
        return new PyTuple(new PyFloat(this.getValue()));
    }

    public PyTuple __getnewargs__() {
        return this.float___getnewargs__();
    }

    public double asDouble() {
        return this.value;
    }

    public static String float___getformat__(PyType type, String typestr) {
        if ("double".equals(typestr)) {
            return double_format.format();
        }
        if ("float".equals(typestr)) {
            return float_format.format();
        }
        throw Py.ValueError("__getformat__() argument 1 must be 'double' or 'float'");
    }

    public static void float___setformat__(PyType type, String typestr, String format) {
        Format new_format = null;
        if (!"double".equals(typestr) && !"float".equals(typestr)) {
            throw Py.ValueError("__setformat__() argument 1 must be 'double' or 'float'");
        }
        if (Format.LE.format().equals(format)) {
            throw Py.ValueError(String.format("can only set %s format to 'unknown' or the detected platform value", typestr));
        }
        if (Format.BE.format().equals(format)) {
            new_format = Format.BE;
        } else if (Format.UNKNOWN.format().equals(format)) {
            new_format = Format.UNKNOWN;
        } else {
            throw Py.ValueError("__setformat__() argument 2 must be 'unknown', 'IEEE, little-endian' or 'IEEE, big-endian'");
        }
        if (new_format != null) {
            if ("double".equals(typestr)) {
                double_format = new_format;
            } else {
                float_format = new_format;
            }
        }
    }

    public boolean isMappingType() {
        return false;
    }

    public boolean isSequenceType() {
        return false;
    }

    static {
        PyType.addBuilder(PyFloat.class, new PyFloat$PyExposer());
        TYPE = PyType.fromClass(PyFloat.class);
        double_format = Format.BE;
        float_format = Format.BE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Format {
        UNKNOWN("unknown"),
        BE("IEEE, big-endian"),
        LE("IEEE, little-endian");

        private final String format;

        private Format(String format) {
            this.format = format;
        }

        public String format() {
            return this.format;
        }
    }
}

