/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.util.Vector;
import org.python.antlr.ParseException;
import org.python.antlr.Visitor;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Suite;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.argumentsType;
import org.python.antlr.ast.exprType;
import org.python.antlr.ast.expr_contextType;
import org.python.antlr.ast.stmtType;

public class ArgListCompiler
extends Visitor {
    public boolean arglist = false;
    public boolean keywordlist = false;
    public exprType[] defaults = null;
    public Vector names = new Vector();
    public Vector fpnames = new Vector();
    public Vector init_code = new Vector();

    public void reset() {
        this.keywordlist = false;
        this.arglist = false;
        this.defaults = null;
        this.names.removeAllElements();
        this.init_code.removeAllElements();
    }

    public void appendInitCode(Suite node) {
        int n = node.body.length;
        Object[] newtree = new stmtType[this.init_code.size() + n];
        this.init_code.copyInto(newtree);
        System.arraycopy(node.body, 0, newtree, this.init_code.size(), n);
        node.body = newtree;
    }

    public exprType[] getDefaults() {
        return this.defaults;
    }

    public void visitArgs(argumentsType args) throws Exception {
        int i;
        for (i = 0; i < args.args.length; ++i) {
            String name = (String)this.visit(args.args[i]);
            this.names.addElement(name);
            if (!(args.args[i] instanceof Tuple)) continue;
            Assign ass = new Assign(args.args[i], new exprType[]{args.args[i]}, (exprType)new Name(args.args[i], name, expr_contextType.Load));
            this.init_code.addElement(ass);
        }
        if (args.vararg != null) {
            this.arglist = true;
            this.names.addElement(args.vararg);
        }
        if (args.kwarg != null) {
            this.keywordlist = true;
            this.names.addElement(args.kwarg);
        }
        this.defaults = args.defaults;
        for (i = 0; i < this.defaults.length; ++i) {
            if (this.defaults[i] != null) continue;
            throw new ParseException("non-default argument follows default argument", args.args[args.args.length - this.defaults.length + i]);
        }
    }

    public Object visitName(Name node) throws Exception {
        if (node.ctx != expr_contextType.Store && node.ctx != expr_contextType.Param) {
            return null;
        }
        if (this.fpnames.contains(node.id)) {
            throw new ParseException("duplicate argument name found: " + node.id, node);
        }
        this.fpnames.addElement(node.id);
        return node.id;
    }

    public Object visitTuple(Tuple node) throws Exception {
        StringBuffer name = new StringBuffer("(");
        int n = node.elts.length;
        for (int i = 0; i < n - 1; ++i) {
            name.append(this.visit(node.elts[i]));
            name.append(", ");
        }
        name.append(this.visit(node.elts[n - 1]));
        name.append(")");
        return name.toString();
    }
}

