/*
 * Decompiled with CFR 0.152.
 */
package com.ziclix.python.sql.handler;

import com.ziclix.python.sql.DataHandler;
import com.ziclix.python.sql.FilterDataHandler;
import com.ziclix.python.sql.zxJDBC;
import java.io.BufferedInputStream;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.driver.OracleResultSet;
import oracle.sql.BLOB;
import oracle.sql.ROWID;
import org.python.core.Py;
import org.python.core.PyObject;

public class OracleDataHandler
extends FilterDataHandler {
    public OracleDataHandler(DataHandler datahandler) {
        super(datahandler);
    }

    public String getMetaDataName(PyObject name) {
        String metaName = super.getMetaDataName(name);
        return metaName == null ? null : metaName.toUpperCase();
    }

    public void setJDBCObject(PreparedStatement stmt, int index, PyObject object, int type) throws SQLException {
        if (DataHandler.checkNull(stmt, index, object, type)) {
            return;
        }
        switch (type) {
            case -8: {
                stmt.setString(index, (String)object.__tojava__(String.class));
                break;
            }
            case 3: {
                Object input = object.__tojava__(Double.class);
                if (input != Py.NoConversion) {
                    stmt.setDouble(index, (Double)input);
                    break;
                }
                super.setJDBCObject(stmt, index, object, type);
                break;
            }
            case 2: {
                super.setJDBCObject(stmt, index, object, 8);
                break;
            }
            case 2004: 
            case 2005: {
                Object[] vals = new Integer[]{new Integer(index), new Integer(type)};
                String msg = zxJDBC.getString("errorSettingIndex", vals);
                throw new SQLException(msg);
            }
            default: {
                super.setJDBCObject(stmt, index, object, type);
            }
        }
    }

    public PyObject getPyObject(ResultSet set, int col, int type) throws SQLException {
        PyObject obj = Py.None;
        switch (type) {
            case 2004: {
                BLOB blob = ((OracleResultSet)set).getBLOB(col);
                if (blob == null) {
                    return Py.None;
                }
                BufferedInputStream stream = new BufferedInputStream(blob.getBinaryStream());
                obj = Py.java2py(DataHandler.read(stream));
                break;
            }
            case -8: {
                ROWID rowid = ((OracleResultSet)set).getROWID(col);
                if (rowid == null) break;
                obj = Py.java2py(rowid.stringValue());
                break;
            }
            default: {
                obj = super.getPyObject(set, col, type);
            }
        }
        return set.wasNull() ? Py.None : obj;
    }

    public void registerOut(CallableStatement statement, int index, int colType, int dataType, String dataTypeName) throws SQLException {
        if (dataType == 1111) {
            if ("REF CURSOR".equals(dataTypeName)) {
                statement.registerOutParameter(index, -10);
                return;
            }
            if ("PL/SQL RECORD".equals(dataTypeName)) {
                statement.registerOutParameter(index, -10);
                return;
            }
        }
        super.registerOut(statement, index, colType, dataType, dataTypeName);
    }
}

