/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestLexer
extends BaseTest {
    protected boolean debug = false;

    public void testSetText() throws Exception {
        String string = "grammar P;\na : A {System.out.println(input);} ;\nA : '\\\\' 't' {setText(\"\t\");} ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "\\t", this.debug);
        TestLexer.assertEquals((String)"\t\n", (String)string2);
    }

    public void testRefToRuleDoesNotSetTokenNorEmitAnother() throws Exception {
        String string = "grammar P;\na : A EOF {System.out.println(input);} ;\nA : '-' I ;\nI : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "-34", this.debug);
        TestLexer.assertEquals((String)"-34\n", (String)string2);
    }

    public void testRefToRuleDoesNotSetChannel() throws Exception {
        String string = "grammar P;\na : A EOF {System.out.println($A.text+\", channel=\"+$A.channel);} ;\nA : '-' WS I ;\nI : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "- 34", this.debug);
        TestLexer.assertEquals((String)"- 34, channel=0\n", (String)string2);
    }

    public void testWeCanSetType() throws Exception {
        String string = "grammar P;\ntokens {X;}\na : X EOF {System.out.println(input);} ;\nA : '-' I {$type = X;} ;\nI : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "-34", this.debug);
        TestLexer.assertEquals((String)"-34\n", (String)string2);
    }

    public void testRefToFragment() throws Exception {
        String string = "grammar P;\na : A {System.out.println(input);} ;\nA : '-' I ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "-34", this.debug);
        TestLexer.assertEquals((String)"-34\n", (String)string2);
    }

    public void testMultipleRefToFragment() throws Exception {
        String string = "grammar P;\na : A EOF {System.out.println(input);} ;\nA : I '.' I ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "3.14159", this.debug);
        TestLexer.assertEquals((String)"3.14159\n", (String)string2);
    }

    public void testLabelInSubrule() throws Exception {
        String string = "grammar P;\na : A EOF ;\nA : 'hi' WS (v=I)? {$channel=0; System.out.println($v.text);} ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "hi 342", this.debug);
        TestLexer.assertEquals((String)"342\n", (String)string2);
    }

    public void testRefToTokenInLexer() throws Exception {
        String string = "grammar P;\na : A EOF ;\nA : I {System.out.println($I.text);} ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "342", this.debug);
        TestLexer.assertEquals((String)"342\n", (String)string2);
    }

    public void testListLabelInLexer() throws Exception {
        String string = "grammar P;\na : A ;\nA : i+=I+ {for (Object t : $i) System.out.print(\" \"+((Token)t).getText());} ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "33 297", this.debug);
        TestLexer.assertEquals((String)" 33 297\n", (String)string2);
    }

    public void testDupListRefInLexer() throws Exception {
        String string = "grammar P;\na : A ;\nA : i+=I WS i+=I {$channel=0; for (Object t : $i) System.out.print(\" \"+((Token)t).getText());} ;\nfragment I : '0'..'9'+ ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;";
        String string2 = this.execParser("P.g", string, "PParser", "PLexer", "a", "33 297", this.debug);
        TestLexer.assertEquals((String)" 33 297\n", (String)string2);
    }

    public void testCharLabelInLexer() {
        String string = "grammar T;\na : B ;\nB : x='a' {System.out.println((char)$x);} ;\n";
        String string2 = this.execParser("T.g", string, "TParser", "TLexer", "a", "a", this.debug);
        TestLexer.assertEquals((String)"a\n", (String)string2);
    }

    public void testRepeatedLabelInLexer() {
        String string = "lexer grammar t;\nB : x='a' x='b' ;\n";
        boolean bl = this.rawGenerateAndBuildRecognizer("t.g", string, null, "tLexer", false);
        boolean bl2 = true;
        TestLexer.assertEquals((boolean)bl2, (boolean)bl);
    }

    public void testRepeatedRuleLabelInLexer() {
        String string = "lexer grammar t;\nB : x=A x=A ;\nfragment A : 'a' ;\n";
        boolean bl = this.rawGenerateAndBuildRecognizer("t.g", string, null, "tLexer", false);
        boolean bl2 = true;
        TestLexer.assertEquals((boolean)bl2, (boolean)bl);
    }

    public void testIsolatedEOTEdge() {
        String string = "lexer grammar T;\nQUOTED_CONTENT \n        : 'q' (~'q')* (('x' 'q') )* 'q' ; \n";
        boolean bl = this.rawGenerateAndBuildRecognizer("T.g", string, null, "TLexer", false);
        boolean bl2 = true;
        TestLexer.assertEquals((boolean)bl2, (boolean)bl);
    }

    public void testEscapedLiterals() {
        String string = "lexer grammar T;\nA : '\\\"' ;\nB : '\\\\\\\"' ;\n";
        boolean bl = this.rawGenerateAndBuildRecognizer("T.g", string, null, "TLexer", false);
        boolean bl2 = true;
        TestLexer.assertEquals((boolean)bl2, (boolean)bl);
    }
}

