/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.analysis;

import antlr.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DFAState;
import org.antlr.analysis.Label;
import org.antlr.analysis.NFAConfiguration;
import org.antlr.analysis.NFAState;
import org.antlr.analysis.RuleClosureTransition;
import org.antlr.analysis.SemanticContext;
import org.antlr.analysis.State;
import org.antlr.analysis.Transition;
import org.antlr.misc.MultiMap;
import org.antlr.misc.Utils;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarAST;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionProbe {
    public DFA dfa;
    protected Set<DFAState> statesWithSyntacticallyAmbiguousAltsSet = new HashSet<DFAState>();
    protected Map<DFAState, Set<Integer>> stateToSyntacticallyAmbiguousTokensRuleAltsMap = new HashMap<DFAState, Set<Integer>>();
    protected Set<DFAState> statesResolvedWithSemanticPredicatesSet = new HashSet<DFAState>();
    protected Map<DFAState, Map<Integer, SemanticContext>> stateToAltSetWithSemanticPredicatesMap = new HashMap<DFAState, Map<Integer, SemanticContext>>();
    protected Map<DFAState, Map<Integer, Set<Token>>> stateToIncompletelyCoveredAltsMap = new HashMap<DFAState, Map<Integer, Set<Token>>>();
    protected Set<DFAState> danglingStates = new HashSet<DFAState>();
    protected Set<Integer> altsWithProblem = new HashSet<Integer>();
    protected boolean nonLLStarDecision = false;
    protected MultiMap<Integer, NFAConfiguration> stateToRecursionOverflowConfigurationsMap = new MultiMap();
    protected boolean timedOut = false;
    protected Map<Integer, Integer> stateReachable;
    public static final Integer REACHABLE_BUSY = Utils.integer(-1);
    public static final Integer REACHABLE_NO = Utils.integer(0);
    public static final Integer REACHABLE_YES = Utils.integer(1);
    protected Set<String> statesVisitedAtInputDepth;
    protected Set<Integer> statesVisitedDuringSampleSequence;
    public static boolean verbose = false;

    public DecisionProbe(DFA dFA) {
        this.dfa = dFA;
    }

    public String getDescription() {
        return this.dfa.getNFADecisionStartState().getDescription();
    }

    public boolean isReduced() {
        return this.dfa.isReduced();
    }

    public boolean isCyclic() {
        return this.dfa.isCyclic();
    }

    public boolean isDeterministic() {
        if (this.danglingStates.size() == 0 && this.statesWithSyntacticallyAmbiguousAltsSet.size() == 0 && this.dfa.getUnreachableAlts().size() == 0) {
            return true;
        }
        if (this.statesWithSyntacticallyAmbiguousAltsSet.size() > 0) {
            for (DFAState dFAState : this.statesWithSyntacticallyAmbiguousAltsSet) {
                if (this.statesResolvedWithSemanticPredicatesSet.contains(dFAState)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean analysisTimedOut() {
        return this.timedOut;
    }

    public boolean analysisOverflowed() {
        return this.stateToRecursionOverflowConfigurationsMap.size() > 0;
    }

    public boolean isNonLLStarDecision() {
        return this.nonLLStarDecision;
    }

    public int getNumberOfStates() {
        return this.dfa.getNumberOfStates();
    }

    public List<Integer> getUnreachableAlts() {
        return this.dfa.getUnreachableAlts();
    }

    public Set getDanglingStates() {
        return this.danglingStates;
    }

    public Set getNonDeterministicAlts() {
        return this.altsWithProblem;
    }

    public List getNonDeterministicAltsForState(DFAState dFAState) {
        Set set = dFAState.getNonDeterministicAlts();
        if (set == null) {
            return null;
        }
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(set);
        Collections.sort(linkedList);
        return linkedList;
    }

    public Set getDFAStatesWithSyntacticallyAmbiguousAlts() {
        return this.statesWithSyntacticallyAmbiguousAltsSet;
    }

    public Set getDisabledAlternatives(DFAState dFAState) {
        return dFAState.getDisabledAlternatives();
    }

    public void removeRecursiveOverflowState(DFAState dFAState) {
        Integer n = Utils.integer(dFAState.stateNumber);
        this.stateToRecursionOverflowConfigurationsMap.remove(n);
    }

    public List<Label> getSampleNonDeterministicInputSequence(DFAState dFAState) {
        Set set = this.getDFAPathStatesToTarget(dFAState);
        this.statesVisitedDuringSampleSequence = new HashSet<Integer>();
        ArrayList<Label> arrayList = new ArrayList<Label>();
        if (this.dfa == null || this.dfa.startState == null) {
            return arrayList;
        }
        this.getSampleInputSequenceUsingStateSet(this.dfa.startState, dFAState, set, arrayList);
        return arrayList;
    }

    public String getInputSequenceDisplay(List list) {
        Grammar grammar = this.dfa.nfa.grammar;
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Label label = (Label)iterator.next();
            stringBuffer.append(label.toString(grammar));
            if (!iterator.hasNext() || grammar.type == 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public List getNFAPathStatesForAlt(int n, int n2, List list) {
        NFAState nFAState;
        NFAState nFAState2 = this.dfa.getNFADecisionStartState();
        LinkedList<NFAState> linkedList = new LinkedList<NFAState>();
        for (int i = n; i <= n2; ++i) {
            nFAState = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nFAState2, i);
            linkedList.add(nFAState);
        }
        NFAState nFAState3 = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nFAState2, n2);
        nFAState = (NFAState)nFAState3.transition[0].target;
        linkedList.add(nFAState);
        this.statesVisitedAtInputDepth = new HashSet<String>();
        this.getNFAPath(nFAState, 0, list, linkedList);
        return linkedList;
    }

    public SemanticContext getSemanticContextForAlt(DFAState dFAState, int n) {
        Map<Integer, SemanticContext> map = this.stateToAltSetWithSemanticPredicatesMap.get(dFAState);
        if (map == null) {
            return null;
        }
        return map.get(Utils.integer(n));
    }

    public boolean hasPredicate() {
        return this.stateToAltSetWithSemanticPredicatesMap.size() > 0;
    }

    public Set getNondeterministicStatesResolvedWithSemanticPredicate() {
        return this.statesResolvedWithSemanticPredicatesSet;
    }

    public Map<Integer, Set<Token>> getIncompletelyCoveredAlts(DFAState dFAState) {
        return this.stateToIncompletelyCoveredAltsMap.get(dFAState);
    }

    public void issueWarnings() {
        Object object;
        Map<Integer, Set<Token>> map;
        Object object2;
        Object object3;
        if (this.nonLLStarDecision && !this.dfa.getAutoBacktrackMode()) {
            ErrorManager.nonLLStarDecision(this);
        }
        if (this.analysisTimedOut()) {
            if (!this.dfa.getAutoBacktrackMode()) {
                ErrorManager.analysisAborted(this);
            }
            return;
        }
        this.issueRecursionWarnings();
        Set set = this.getNondeterministicStatesResolvedWithSemanticPredicate();
        Set set2 = this.getDFAStatesWithSyntacticallyAmbiguousAlts();
        if (set2.size() > 0) {
            object3 = set2.iterator();
            while (object3.hasNext() && !this.dfa.nfa.grammar.NFAToDFAConversionExternallyAborted()) {
                object2 = (DFAState)object3.next();
                map = this.getIncompletelyCoveredAlts((DFAState)object2);
                if (map != null && map.size() > 0) {
                    ErrorManager.insufficientPredicates(this, (DFAState)object2, map);
                }
                if (set != null && set.contains(object2)) continue;
                object = this.getDisabledAlternatives((DFAState)object2);
                this.stripWildCardAlts((Set)object);
                if (object.size() <= 0) continue;
                ErrorManager.nondeterminism(this, (DFAState)object2);
            }
        }
        if ((object3 = this.getDanglingStates()).size() > 0) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                map = (DFAState)object2.next();
                ErrorManager.danglingState(this, (DFAState)((Object)map));
            }
        }
        if (!this.nonLLStarDecision && (object2 = this.dfa.getUnreachableAlts()) != null && object2.size() > 0) {
            boolean bl = false;
            if (this.dfa.isTokensRuleDecision()) {
                object = object2.iterator();
                while (object.hasNext()) {
                    Integer n = (Integer)object.next();
                    GrammarAST grammarAST = this.dfa.getDecisionASTNode();
                    GrammarAST grammarAST2 = grammarAST.getChild(n - 1);
                    GrammarAST grammarAST3 = grammarAST2.getFirstChildWithType(39);
                    if (grammarAST3 == null) continue;
                    bl = true;
                    ErrorManager.grammarWarning(162, this.dfa.nfa.grammar, null, this.dfa.nfa.grammar.name, grammarAST3.getFirstChild().getText());
                }
            }
            if (!bl) {
                ErrorManager.unreachableAlts(this, (List)object2);
            }
        }
    }

    protected void stripWildCardAlts(Set set) {
        ArrayList arrayList = new ArrayList(set);
        Collections.sort(arrayList);
        Integer n = (Integer)arrayList.get(arrayList.size() - 1);
        GrammarAST grammarAST = this.dfa.nfa.grammar.getDecisionBlockAST(this.dfa.decisionNumber);
        GrammarAST grammarAST2 = null;
        grammarAST2 = grammarAST.getChild(0).getType() == 4 ? grammarAST.getChild(n) : grammarAST.getChild(n - 1);
        if (grammarAST2.getType() != 19 && grammarAST2.getChild(0).getType() == 72 && grammarAST2.getChild(1).getType() == 20) {
            set.remove(n);
        }
    }

    protected void issueRecursionWarnings() {
        Set set = this.stateToRecursionOverflowConfigurationsMap.keySet();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        this.computeAltToProblemMaps(set, this.stateToRecursionOverflowConfigurationsMap, hashMap, hashMap2);
        Set set2 = hashMap.keySet();
        ArrayList arrayList = new ArrayList(set2);
        Collections.sort(arrayList);
        for (Integer n : arrayList) {
            Map map = (Map)hashMap.get(n);
            Set set3 = map.keySet();
            Collection collection = map.values();
            DFAState dFAState = (DFAState)hashMap2.get(n);
            ErrorManager.recursionOverflow(this, dFAState, n, set3, collection);
        }
    }

    private void computeAltToProblemMaps(Set set, Map map, Map map2, Map map3) {
        for (Integer n : set) {
            List list = (List)map.get(n);
            for (int i = 0; i < list.size(); ++i) {
                HashSet<NFAState> hashSet;
                NFAConfiguration nFAConfiguration = (NFAConfiguration)list.get(i);
                NFAState nFAState = this.dfa.nfa.getState(nFAConfiguration.state);
                Transition transition = nFAState.transition[0];
                RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)transition;
                String string = ((NFAState)ruleClosureTransition.target).enclosingRule.name;
                Integer n2 = Utils.integer(nFAConfiguration.alt);
                HashMap<String, HashSet<NFAState>> hashMap = (HashMap<String, HashSet<NFAState>>)map2.get(n2);
                if (hashMap == null) {
                    hashMap = new HashMap<String, HashSet<NFAState>>();
                    map2.put(n2, hashMap);
                }
                if ((hashSet = (HashSet<NFAState>)hashMap.get(string)) == null) {
                    hashSet = new HashSet<NFAState>();
                    hashMap.put(string, hashSet);
                }
                hashSet.add(nFAState);
                if (map3.get(n2) != null) continue;
                DFAState dFAState = this.dfa.getState(n);
                map3.put(n2, dFAState);
            }
        }
    }

    private Set getUnaliasedDFAStateSet(Set set) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (Integer n : set) {
            DFAState dFAState = this.dfa.getState(n);
            hashSet.add(Utils.integer(dFAState.stateNumber));
        }
        return hashSet;
    }

    public void reportDanglingState(DFAState dFAState) {
        this.danglingStates.add(dFAState);
    }

    public void reportAnalysisTimeout() {
        this.timedOut = true;
        this.dfa.nfa.grammar.setOfDFAWhoseAnalysisTimedOut.add(this.dfa);
    }

    public void reportNonLLStarDecision(DFA dFA) {
        this.nonLLStarDecision = true;
        this.altsWithProblem.addAll(dFA.recursiveAltSet.toList());
    }

    public void reportRecursionOverflow(DFAState dFAState, NFAConfiguration nFAConfiguration) {
        if (dFAState.stateNumber > 0) {
            Integer n = Utils.integer(dFAState.stateNumber);
            this.stateToRecursionOverflowConfigurationsMap.map(n, nFAConfiguration);
        }
    }

    public void reportNondeterminism(DFAState dFAState, Set<Integer> set) {
        this.altsWithProblem.addAll(set);
        this.statesWithSyntacticallyAmbiguousAltsSet.add(dFAState);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbers.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportLexerRuleNondeterminism(DFAState dFAState, Set<Integer> set) {
        this.stateToSyntacticallyAmbiguousTokensRuleAltsMap.put(dFAState, set);
    }

    public void reportNondeterminismResolvedWithSemanticPredicate(DFAState dFAState) {
        if (dFAState.abortedDueToRecursionOverflow) {
            dFAState.dfa.probe.removeRecursiveOverflowState(dFAState);
        }
        this.statesResolvedWithSemanticPredicatesSet.add(dFAState);
        this.dfa.nfa.grammar.setOfNondeterministicDecisionNumbersResolvedWithPredicates.add(Utils.integer(this.dfa.getDecisionNumber()));
    }

    public void reportAltPredicateContext(DFAState dFAState, Map map) {
        HashMap hashMap = new HashMap();
        hashMap.putAll(map);
        this.stateToAltSetWithSemanticPredicatesMap.put(dFAState, hashMap);
    }

    public void reportIncompletelyCoveredAlts(DFAState dFAState, Map<Integer, Set<Token>> map) {
        this.stateToIncompletelyCoveredAltsMap.put(dFAState, map);
    }

    protected boolean reachesState(DFAState dFAState, DFAState dFAState2, Set set) {
        if (dFAState == dFAState2) {
            set.add(dFAState2);
            this.stateReachable.put(new Integer(dFAState.stateNumber), REACHABLE_YES);
            return true;
        }
        DFAState dFAState3 = dFAState;
        this.stateReachable.put(new Integer(dFAState3.stateNumber), REACHABLE_BUSY);
        for (int i = 0; i < dFAState3.getNumberOfTransitions(); ++i) {
            Transition transition = dFAState3.transition(i);
            DFAState dFAState4 = (DFAState)transition.target;
            Integer n = this.stateReachable.get(new Integer(dFAState4.stateNumber));
            if (n == REACHABLE_BUSY) continue;
            if (n == REACHABLE_YES) {
                this.stateReachable.put(new Integer(dFAState3.stateNumber), REACHABLE_YES);
                return true;
            }
            if (n == REACHABLE_NO || !this.reachesState(dFAState4, dFAState2, set)) continue;
            set.add(dFAState3);
            this.stateReachable.put(new Integer(dFAState3.stateNumber), REACHABLE_YES);
            return true;
        }
        this.stateReachable.put(new Integer(dFAState3.stateNumber), REACHABLE_NO);
        return false;
    }

    protected Set getDFAPathStatesToTarget(DFAState dFAState) {
        HashSet hashSet = new HashSet();
        this.stateReachable = new HashMap<Integer, Integer>();
        if (this.dfa == null || this.dfa.startState == null) {
            return hashSet;
        }
        boolean bl = this.reachesState(this.dfa.startState, dFAState, hashSet);
        return hashSet;
    }

    protected void getSampleInputSequenceUsingStateSet(State state, State state2, Set set, List<Label> list) {
        this.statesVisitedDuringSampleSequence.add(new Integer(state.stateNumber));
        for (int i = 0; i < state.getNumberOfTransitions(); ++i) {
            Transition transition = state.transition(i);
            DFAState dFAState = (DFAState)transition.target;
            if (!set.contains(dFAState) || this.statesVisitedDuringSampleSequence.contains(new Integer(dFAState.stateNumber))) continue;
            list.add(transition.label);
            if (dFAState != state2) {
                this.getSampleInputSequenceUsingStateSet(dFAState, state2, set, list);
            }
            return;
        }
        list.add(new Label(-5));
    }

    protected boolean getNFAPath(NFAState nFAState, int n, List list, List list2) {
        String string = this.getStateLabelIndexKey(nFAState.stateNumber, n);
        if (this.statesVisitedAtInputDepth.contains(string)) {
            return false;
        }
        this.statesVisitedAtInputDepth.add(string);
        for (int i = 0; i < nFAState.getNumberOfTransitions(); ++i) {
            boolean bl;
            Transition transition = nFAState.transition[i];
            NFAState nFAState2 = (NFAState)transition.target;
            Label label = (Label)list.get(n);
            if (transition.label.isEpsilon() || transition.label.isSemanticPredicate()) {
                list2.add(nFAState2);
                bl = this.getNFAPath(nFAState2, n, list, list2);
                if (bl) {
                    this.statesVisitedAtInputDepth.remove(string);
                    return true;
                }
                list2.remove(list2.size() - 1);
                continue;
            }
            if (!transition.label.matches(label)) continue;
            list2.add(nFAState2);
            if (n == list.size() - 1) {
                this.statesVisitedAtInputDepth.remove(string);
                return true;
            }
            bl = this.getNFAPath(nFAState2, n + 1, list, list2);
            if (bl) {
                this.statesVisitedAtInputDepth.remove(string);
                return true;
            }
            list2.remove(list2.size() - 1);
        }
        this.statesVisitedAtInputDepth.remove(string);
        return false;
    }

    protected String getStateLabelIndexKey(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n);
        stringBuffer.append('_');
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    public String getTokenNameForTokensRuleAlt(int n) {
        NFAState nFAState = this.dfa.getNFADecisionStartState();
        NFAState nFAState2 = this.dfa.nfa.grammar.getNFAStateForAltOfDecision(nFAState, n);
        NFAState nFAState3 = (NFAState)nFAState2.transition[0].target;
        RuleClosureTransition ruleClosureTransition = (RuleClosureTransition)nFAState3.transition[0];
        NFAState nFAState4 = (NFAState)ruleClosureTransition.target;
        return nFAState4.enclosingRule.name;
    }

    public void reset() {
        this.stateToRecursionOverflowConfigurationsMap.clear();
    }
}

