% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourceSHAPE.R
\name{defineSHAPE}
\alias{defineSHAPE}
\title{These are some global reference options that SHAPE will use and I consider the defaults.
SHAPE parameters can be changed by calling this function and changing values OR
by using the accessory SHAPE_parameters script, called in the SHAPE_runBody script.
This second approach is considered more practical for building and running experiments.}
\usage{
defineSHAPE(shape_allow_backMutations = TRUE,
  shape_collapseString = "__:__", shape_constDist = "exp",
  shape_const_relativeFitness = TRUE,
  shape_const_hoodDepth = "limited",
  shape_const_focal_popValue = 1e+05, shape_const_mutProb = 0.001,
  shape_const_distParameters = 20, shape_const_distAsS = FALSE,
  shape_const_RMF_initiDistance = 5, shape_const_RMF_theta = 0.35,
  shape_const_numInteractions = 4, shape_const_fixedFrame = NULL,
  shape_const_birthProb = 1, shape_const_deathProb = 1,
  shape_const_ancestFitness = 0, shape_const_estProp = 0.001,
  shape_const_hoodThresh = 1000, shape_const_distType = "bottleneck",
  shape_const_growthForm = "logistic", shape_const_growthRate = 2,
  shape_const_growthGenerations = NULL, shape_db_splitTables = TRUE,
  shape_death_byDensity = TRUE, shape_death_densityCorrelation = 4,
  shape_death_densityCap = NULL, shape_envString = "shapeEnvir",
  shape_externalSelfing = FALSE,
  shape_external_stopFile = "someNamed.file", shape_finalDir = NULL,
  shape_genomeLength = 100, shape_includeDrift = TRUE,
  shape_init_distPars = c(factor = 100, random = 1),
  shape_maxReplicates = 30, shape_maxRows = 2.5e+07,
  shape_muts_onlyBirths = FALSE, shape_nextID = 0,
  shape_numGenerations = 100, shape_objectStrings = c(popDemographics =
  "popDemo", repeatability = "evoRepeat"), shape_postDir = NULL,
  shape_recycle_repStart = 1, shape_results_removeSteps = TRUE,
  shape_run_isRecycling = c(Landscape = TRUE, Steps = FALSE, Parameters =
  TRUE, Neighbourhood = FALSE), shape_save_batchBase = "yourJob",
  shape_save_batchSet = 1, shape_save_batchJob = 1,
  shape_scaleGrowth_byDeaths = TRUE, shape_sepString = "_",
  shape_sepLines = "__and__", shape_serverFarm = FALSE,
  shape_simModel = "HoC", shape_size_timeStep = 1,
  shape_stringsAsFactors = FALSE, shape_string_lineDescent = "_->_",
  shape_string_tableNames = "numMutations", shape_thisRep = 1,
  shape_tmpGenoTable = NULL,
  shape_tmp_selfScript = "~/random_nullFile.txt", shape_use_sigFig = 4,
  shape_toggle_forceCompletion = FALSE, shape_track_asWhole = FALSE,
  shape_track_distSize = NULL, shape_workDir = NULL)
}
\arguments{
\item{shape_allow_backMutations}{This is a logical toggle controlling if revertant mutants are allowed.}

\item{shape_collapseString}{This is a string to collapse the progenitor and number of mutants pieces of information.}

\item{shape_constDist}{This is a character string to control the distribution used for drawing fitness value random components.}

\item{shape_const_relativeFitness}{This is a logical toggle which controls if the absolute fitness values calculated should be reinterpreted as relative fitness values.}

\item{shape_const_hoodDepth}{shape_const_hoodDepth This is an object to control which strains we get deep neighbourhood information for
It should be one of \strong{"none","limited","priority","full"}
setting this higher will cost more and more in post analysis runtime.}

\item{shape_const_focal_popValue}{This is the focal population value which has different meanings based on the growth model implemented.}

\item{shape_const_mutProb}{This is the probability of a mutation event - occuring relative to the number of mutable events - in a standard biological generation.}

\item{shape_const_distParameters}{This allows a single parameter to be passed for use in the distribution of fitness fitness effects.  NOTE: you are likely going to
want to pass multiple values in which case simply set this value prior to a run's start but after loading the library.}

\item{shape_const_distAsS}{This is a logical toggle controlling if fitness landscape values calculated should be interpreted as selection coefficients rather than relative
fitness values.}

\item{shape_const_RMF_initiDistance}{This is the distance of the independent global fitness optima away from the WT genotype.  It matters for the Rough Mount Fuji landscapes.}

\item{shape_const_RMF_theta}{This is the Rough Mount Fuji value that controls the scalar of the independent fitness contribution.}

\item{shape_const_numInteractions}{This is the number of sites which interact with respect to fitness calculations in models such as the NK.}

\item{shape_const_fixedFrame}{This defines the fitness landscape when our model is "Fixed", it must be user defined and be explicit to all genotypes possible.}

\item{shape_const_birthProb}{This is the proportion of individuals with fitness == 1 having births events in a standard biological generation.}

\item{shape_const_deathProb}{This is the proportion of individuals having a death event in a standard biological generation.}

\item{shape_const_ancestFitness}{This is the fitness value of the ancestral genotype.}

\item{shape_const_estProp}{This is the value controlling when SHAPE considers a population to be established.}

\item{shape_const_hoodThresh}{This is the numeric value controlling when a population is of sufficient size for SHAPE to consider
it worth having the genotype's mutational neighbourhood to be stored in a convenience DB for easier access - ie: this can save
computational time but will cost diskspace during the run.}

\item{shape_const_distType}{This is the type of stochastic disturbance events to be simulated.}

\item{shape_const_growthForm}{This is the growth form model to be simulated}

\item{shape_const_growthRate}{This is the number of offspring from every division event where 1 would mean replacement,
2 is normal binary fission, etc....}

\item{shape_const_growthGenerations}{This is an optional integer value controlling if you want a standard number of time steps between
each stochastic disturbance function call.  Not defining this means it will be calculated based on other paratmerts defined.}

\item{shape_db_splitTables}{This is a logical toggle as to whether or not fitness landscape tables - for genotypes with the same number
of mutations - are allowed to be split into sub-tables.}

\item{shape_death_byDensity}{This is the logical toggle controlling if deaths are density dependent.}

\item{shape_death_densityCorrelation}{This is a positive numeric controlling the rate at which density dependent deaths increase from
minimal to maximal effect.  Where 1 is linear, > 1 creates an exponential form of curve and values < 1 will create a root function curve.}

\item{shape_death_densityCap}{If deaths are density dependent this is the maximal community size for when deaths are 100\% expected.}

\item{shape_envString}{This is a string used for programatically creating workspace environments for rSHAPE}

\item{shape_externalSelfing}{This is the logical toggle controlling if replicates are to be handled as individual external calls
rather than through the normal internal for loop.  It has limited value and was desgined for when you work on compute nodes with
limited wall time.}

\item{shape_external_stopFile}{This is the filename for a file which is used to control self-replciation of SHAPE when selfing is external.}

\item{shape_finalDir}{This is the directory where file from a remote server's compute node are to be back ported regularly.  Only matters
under the correct conditions.}

\item{shape_genomeLength}{This is the length of a simulant's genome, or in other words the number of sites where mutations can occur.}

\item{shape_includeDrift}{This is a logical toggle as to whether or not we should add stochasticity to the growth function
calculations.  It is meant to simulate drift in calculations that would otherwise be deterministic.}

\item{shape_init_distPars}{This is the vector of initial values of the dilution factor and random component of the stochastic disturbance function.
It needs to be set with a number and range of values approriate to the distribution to be simulated.}

\item{shape_maxReplicates}{This is the number of replicates to be run.}

\item{shape_maxRows}{This is the integer number of rows stored in a single table of the fitness landscape DB.  Only
matters is tables are aplit/}

\item{shape_muts_onlyBirths}{This is a logical flag to control if mutants only appear as a result of birth events.}

\item{shape_nextID}{This is the next genotype ID to be assigned for a genotype that get's created.}

\item{shape_numGenerations}{This is the number of generations to be simulated in the run.}

\item{shape_objectStrings}{This is a named character vector which are the string prefixes used when programatically naming objects.}

\item{shape_postDir}{This is the filepath to the directory where post-analysis results will be stored.}

\item{shape_recycle_repStart}{This is the first replicate being simulated once a SHAPE call is made.}

\item{shape_results_removeSteps}{This is a logical flag controlling if the steps log is removed after being processed.}

\item{shape_run_isRecycling}{This is a named vector of four logicals which control which parts of a run is meant to be recycled between replicates.}

\item{shape_save_batchBase}{This is a character string for naming your experiment.}

\item{shape_save_batchSet}{This is an integer value for the set of this experiment associated to this job.}

\item{shape_save_batchJob}{This is an integer value for the batch of this experiment associated to this job.}

\item{shape_scaleGrowth_byDeaths}{This is a logical flag that controls if growth is scaled by deaths so that the growth
form follows standard expectations.}

\item{shape_sepString}{This is a string character that is used for collpasing vectors of information into a single
character string, and subsequently splitting that information back out.}

\item{shape_sepLines}{This is a string character that is used in collapsing multiple elements into a single character string
though namely employed in the summariseExperiment function.}

\item{shape_serverFarm}{This is a logical flag of whether or not your simulations are going to be run on a remote server
or other situation with compute and host nodes where you might want to handle particularities I experienced and thus accounted for.}

\item{shape_simModel}{This is the fitness landscape model to be simulated.}

\item{shape_size_timeStep}{This is the proportion of a standard biological generation to be simulated in a single time step
of a SHAPE run.  Values greater than 1 are not guaranteed to work as expected.  Negative numbers will cause errors.}

\item{shape_stringsAsFactors}{I don't like strings to be factors and so SHAPE will avoid treating them as so.}

\item{shape_string_lineDescent}{This is a string that will be used to collapse vectors of character strings into a single string
It get's used when we are tracking sequential genotypes through the line of descent}

\item{shape_string_tableNames}{This is a string value used as the prefix when naming table in the fitness landscape DB.}

\item{shape_thisRep}{This is the replicate number of the first replicate processed in the called run.}

\item{shape_tmpGenoTable}{This is a temporary object of a table of genotype information that is to be passed along
different functions of SHAPE.  It's stored as an option since it can be build within a function where it is not returned
as an object but then used later.  There is little value in setting this manually.}

\item{shape_tmp_selfScript}{This is an optionally defined filepath location for a file that will exist to signal that
an externally replicating SHAPE run can stop.  This only matters if selfing is external.}

\item{shape_use_sigFig}{This is the number of significant figures that will be kept for processed output.}

\item{shape_toggle_forceCompletion}{This is a logical toggle controlling if a run crashes when it is ended prior to the
maximum number of replicates being completed.}

\item{shape_track_asWhole}{This is a logical toggle controlling if population sizes must be tracked as integer values}

\item{shape_track_distSize}{This is a numeric, the size of a disturbance caused by stochastic events.  It is the dilution factor
or the divisor of the community size.  It must be > 1 or is forced to that value.}

\item{shape_workDir}{This is the main working directory relative to which your SHAPE experiment will be built and run.  It defaults
to the -- tempdir -- of R when this value is NULL, I strongly recommend}
}
\description{
These are some global reference options that SHAPE will use and I consider the defaults.
SHAPE parameters can be changed by calling this function and changing values OR
by using the accessory SHAPE_parameters script, called in the SHAPE_runBody script.
This second approach is considered more practical for building and running experiments.
}
\section{Warning}{

Please pass a directory filepath to the argument of shape_workDir, rSHAPE will create this so it needn't exist yet.
If you leave it as the default -- ie NULL -- whatever is created will simply be lost in the temporary folder
of this R sessions' workspace.
}

\examples{
# This function builds the basic parameters for a run of SHAPE and I recommend as
# the most convenient wayfor setting your own parameters since this function will
# make appropriate derived settings based on values passed.
# You must at least call it before using runSHAPE() or shapeExperiment().

# You can see there are a lot of parameters for SHAPE
args(defineSHAPE)
# Here are some default values that were just loaded as options
sapply(c("shape_workDir","shape_save_batchJob","shape_save_batchBase", "shape_simModel"),getOption)
# As an exmaple we change your working directory, the ID of the job and the fitness landscape model
options(list("shape_workDir" = paste(tempdir(),"~/alternativeFolder/",sep=""),
                "shape_save_batchJob" = 3, "shape_save_batchBase" = "non_default_Experiment",
                "shape_simModel" = "NK"))
sapply(c("shape_workDir","shape_save_batchJob","shape_save_batchBase", "shape_simModel"),getOption)
# NOTE: that manually setting the options will not create a new working directory for rSHAPE,
# you would need to do this yourself or could simply pass these arguments through a call
# to defineSHAPE().

}
