% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safely_detect_interactions.R
\name{safely_detect_interactions}
\alias{safely_detect_interactions}
\title{Detecting Interactions via Permutation Approach}
\usage{
safely_detect_interactions(
  explainer,
  inter_param = 0.5,
  inter_threshold = 0.5,
  verbose = TRUE
)
}
\arguments{
\item{explainer}{DALEX explainer created with explain() function}

\item{inter_param}{numeric, a positive value indicating which of single observation non-additive effects
are to be regarded as significant, the higher value the higher non-additive effect has to be to be taken
into account}

\item{inter_threshold}{numeric, a value from \verb{[0,1]} interval indicating which interactions should be returned
as significant. It corresponds to the percentage of observations for which interaction measure is greater
than inter_param - if this percentage is less than inter_threshold then interaction effect is ignored.}

\item{verbose}{logical, if progress bar is to be printed}
}
\value{
dataframe object containing interactions effects greater than or equal to the specified inter_threshold
}
\description{
The safely_detect_interactions() function detects second-order interactions based on predictions
made by a surrogate model. For each pair of features it performs values permutation in order
to evaluate their non_additive effect.
}
\examples{

library(DALEX)
library(randomForest)
library(rSAFE)

data <- apartments[1:500,]
set.seed(111)
model_rf <- randomForest(m2.price ~ construction.year + surface + floor +
                           no.rooms + district, data = data)
explainer_rf <- explain(model_rf, data = data[,2:6], y = data[,1])
safely_detect_interactions(explainer_rf, inter_param = 0.25,
                          inter_threshold = 0.2, verbose = TRUE)

}
\seealso{
\code{\link{safe_extraction}}
}
