% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpraat.R
\name{tg.removeIntervalLeftBoundary}
\alias{tg.removeIntervalLeftBoundary}
\title{tg.removeIntervalLeftBoundary}
\usage{
tg.removeIntervalLeftBoundary(tg, tierInd, index)
}
\arguments{
\item{tg}{TextGrid object}

\item{tierInd}{tier index or "name"}

\item{index}{index of the interval}
}
\value{
TextGrid object
}
\description{
Remove left boundary of the interval of the given index in Interval tier.
In fact, it concatenates two intervals into one (and their labels). It
cannot be applied to the first interval because it is the start boundary
of the tier.
E.g., we have interval 1-2-3, we remove the left boundary of the 2nd
interval, the result is two intervals 12-3.
If we do not want to concatenate labels, we have to set the label
to the empty string "" before this operation.
}
\examples{
\dontrun{
tg <- tg.sample()
tg.plot(tg)
tg2 <- tg.removeIntervalLeftBoundary(tg, "word", 3)
tg.plot(tg2)
}
}
\seealso{
\code{\link{tg.removeIntervalRightBoundary}}, \code{\link{tg.removeIntervalBothBoundaries}}, \code{\link{tg.insertBoundary}}, \code{\link{tg.insertInterval}}
}
