% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSamples.R
\name{getSamples}
\alias{getSamples}
\title{Download the expression matrix and annotations from the panglaoDB database.}
\usage{
getSamples(
  sra = "All",
  srs = "All",
  tissue = "All",
  protocol = "All",
  specie = "All",
  celltype = "All",
  merge = TRUE
)
}
\arguments{
\item{sra}{Filter based on the SRA identifier of the biological sample in the SRA database}

\item{srs}{Filter based on the SRS identifier of the biological sample in the SRA database}

\item{tissue}{Filter based on the tissue from which the biological samples originates from}

\item{protocol}{Filter based on the single-cell library preparation protocol used to generate the data}

\item{specie}{Filter based on the specie from which the biological samples originates from}

\item{celltype}{Filter based on the cell-type from which the counts originates from}

\item{merge}{A boolean value TRUE or FALSE defining if the samples should be returned as a list or as a unique Seurat object}
}
\value{
A Seurat object, as described in \code{?SeuratObject::`Seurat-class`}
}
\description{
Download the expression matrix and annotations from the panglaoDB database.
}
\examples{
# From PanglaoDB SRS3805255
# https://panglaodb.se/view_data.php?sra=SRA705190&srs=SRS4139632

\dontrun{
SRS4139632 <- getSamples(srs = 'SRS4139632')
SRS4139632}

# An object of class Seurat
# 19859 features across 102 samples within 1 assay
# Active assay: RNA (19859 features, 0 variable features)

# Metadata from the PanglaoDB database can be accessed as follows:
# head(SRS4139632[[]])
}
